/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;

class TermsIncludingScoreQuery
extends Query {
    final String field;
    final boolean multipleValuesPerDocument;
    final BytesRefHash terms;
    final float[] scores;
    final int[] ords;
    final Query originalQuery;
    final Query unwrittenOriginalQuery;

    TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, Query originalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.unwrittenOriginalQuery = originalQuery;
    }

    private TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, int[] ords, Query originalQuery, Query unwrittenOriginalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = ords;
        this.unwrittenOriginalQuery = unwrittenOriginalQuery;
    }

    public String toString(String string) {
        return String.format(Locale.ROOT, "TermsIncludingScoreQuery{field=%s;originalQuery=%s}", this.field, this.unwrittenOriginalQuery);
    }

    public void extractTerms(Set<Term> terms) {
        this.originalQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query originalQueryRewrite = this.originalQuery.rewrite(reader);
        if (originalQueryRewrite != this.originalQuery) {
            TermsIncludingScoreQuery rewritten = new TermsIncludingScoreQuery(this.field, this.multipleValuesPerDocument, this.terms, this.scores, this.ords, originalQueryRewrite, this.originalQuery);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        final Weight originalWeight = this.originalQuery.createWeight(searcher);
        return new Weight(){
            private TermsEnum segmentTermsEnum;

            public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
                SVInnerScorer scorer = (SVInnerScorer)this.scorer(context, false, false, context.reader().getLiveDocs());
                if (scorer != null && scorer.advanceForExplainOnly(doc) == doc) {
                    return scorer.explain();
                }
                return new ComplexExplanation(false, 0.0f, "Not a match");
            }

            public Query getQuery() {
                return TermsIncludingScoreQuery.this;
            }

            public float getValueForNormalization() throws IOException {
                return originalWeight.getValueForNormalization() * TermsIncludingScoreQuery.this.getBoost() * TermsIncludingScoreQuery.this.getBoost();
            }

            public void normalize(float norm, float topLevelBoost) {
                originalWeight.normalize(norm, topLevelBoost * TermsIncludingScoreQuery.this.getBoost());
            }

            public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.field);
                if (terms == null) {
                    return null;
                }
                this.segmentTermsEnum = terms.iterator(this.segmentTermsEnum);
                if (scoreDocsInOrder) {
                    if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                        return new MVInOrderScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc());
                    }
                    return new SVInOrderScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc());
                }
                if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                    return new MVInnerScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc());
                }
                return new SVInnerScorer(this, acceptDocs, this.segmentTermsEnum);
            }
        };
    }

    class MVInOrderScorer
    extends SVInOrderScorer {
        MVInOrderScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc) throws IOException {
            super(weight, acceptDocs, termsEnum, maxDoc);
        }

        @Override
        protected void fillDocsAndScores(FixedBitSet matchingDocs, Bits acceptDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            DocsEnum docsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare), true)) continue;
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = docsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!matchingDocs.get(doc)) {
                        this.scores[doc] = score;
                        matchingDocs.set(doc);
                    }
                    doc = docsEnum.nextDoc();
                }
            }
        }
    }

    class SVInOrderScorer
    extends Scorer {
        final DocIdSetIterator matchingDocsIterator;
        final float[] scores;
        int currentDoc;

        SVInOrderScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc) throws IOException {
            super(weight);
            this.currentDoc = -1;
            FixedBitSet matchingDocs = new FixedBitSet(maxDoc);
            this.scores = new float[maxDoc];
            this.fillDocsAndScores(matchingDocs, acceptDocs, termsEnum);
            this.matchingDocsIterator = matchingDocs.iterator();
        }

        protected void fillDocsAndScores(FixedBitSet matchingDocs, Bits acceptDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            DocsEnum docsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare), true)) continue;
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = docsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    matchingDocs.set(doc);
                    this.scores[doc] = score;
                    doc = docsEnum.nextDoc();
                }
            }
        }

        public float score() throws IOException {
            return this.scores[this.currentDoc];
        }

        public float freq() throws IOException {
            return 1.0f;
        }

        public int docID() {
            return this.currentDoc;
        }

        public int nextDoc() throws IOException {
            this.currentDoc = this.matchingDocsIterator.nextDoc();
            return this.currentDoc;
        }

        public int advance(int target) throws IOException {
            this.currentDoc = this.matchingDocsIterator.advance(target);
            return this.currentDoc;
        }
    }

    class MVInnerScorer
    extends SVInnerScorer {
        final FixedBitSet alreadyEmittedDocs;

        MVInnerScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc) {
            super(weight, acceptDocs, termsEnum);
            this.alreadyEmittedDocs = new FixedBitSet(maxDoc);
        }

        @Override
        public int nextDoc() throws IOException {
            int docId;
            if (this.docsEnum != null) {
                while ((docId = this.docsEnum.nextDoc()) != Integer.MAX_VALUE && this.alreadyEmittedDocs.get(docId)) {
                }
                if (docId == Integer.MAX_VALUE) {
                    this.docsEnum = null;
                } else {
                    this.alreadyEmittedDocs.set(docId);
                    return docId;
                }
            }
            while (true) {
                if (this.upto == TermsIncludingScoreQuery.this.terms.size()) {
                    return Integer.MAX_VALUE;
                }
                this.scoreUpto = this.upto;
                if (this.termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[this.upto++], this.spare), true)) {
                    this.docsEnum = this.reuse = this.termsEnum.docs(this.acceptDocs, this.reuse, 0);
                }
                if (this.docsEnum == null) continue;
                while ((docId = this.docsEnum.nextDoc()) != Integer.MAX_VALUE && this.alreadyEmittedDocs.get(docId)) {
                }
                if (docId != Integer.MAX_VALUE) break;
                this.docsEnum = null;
            }
            this.alreadyEmittedDocs.set(docId);
            return docId;
        }
    }

    class SVInnerScorer
    extends Scorer {
        final BytesRef spare;
        final Bits acceptDocs;
        final TermsEnum termsEnum;
        int upto;
        DocsEnum docsEnum;
        DocsEnum reuse;
        int scoreUpto;

        SVInnerScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum) {
            super(weight);
            this.spare = new BytesRef();
            this.acceptDocs = acceptDocs;
            this.termsEnum = termsEnum;
        }

        public float score() throws IOException {
            return TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[this.scoreUpto]];
        }

        public Explanation explain() throws IOException {
            return new ComplexExplanation(true, this.score(), "Score based on join value " + this.termsEnum.term().utf8ToString());
        }

        public int docID() {
            return this.docsEnum != null ? this.docsEnum.docID() : Integer.MAX_VALUE;
        }

        public int nextDoc() throws IOException {
            if (this.docsEnum != null) {
                int docId = this.docsEnum.nextDoc();
                if (docId == Integer.MAX_VALUE) {
                    this.docsEnum = null;
                } else {
                    return docId;
                }
            }
            do {
                if (this.upto == TermsIncludingScoreQuery.this.terms.size()) {
                    return Integer.MAX_VALUE;
                }
                this.scoreUpto = this.upto;
                if (!this.termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[this.upto++], this.spare), true)) continue;
                this.docsEnum = this.reuse = this.termsEnum.docs(this.acceptDocs, this.reuse, 0);
            } while (this.docsEnum == null);
            return this.docsEnum.nextDoc();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException("advance() isn't supported because doc ids are emitted out of order");
        }

        private int advanceForExplainOnly(int target) throws IOException {
            int docId;
            do {
                if ((docId = this.nextDoc()) < target) {
                    int tempDocId = this.docsEnum.advance(target);
                    if (tempDocId == target) {
                        docId = tempDocId;
                        break;
                    }
                } else if (docId == target) break;
                this.docsEnum = null;
            } while (docId != Integer.MAX_VALUE);
            return docId;
        }

        public float freq() {
            return 1.0f;
        }
    }
}

