/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToChildBlockJoinQuery
extends Query {
    private final Filter parentsFilter;
    private final Query parentQuery;
    private final Query origParentQuery;
    private final boolean doScores;

    public ToChildBlockJoinQuery(Query parentQuery, Filter parentsFilter, boolean doScores) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    private ToChildBlockJoinQuery(Query origParentQuery, Query parentQuery, Filter parentsFilter, boolean doScores) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher), this.parentsFilter, this.doScores);
    }

    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            ToChildBlockJoinQuery rewritten = new ToChildBlockJoinQuery(this.parentQuery, parentRewrite, this.parentsFilter, this.doScores);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToChildBlockJoinQuery) {
            ToChildBlockJoinQuery other = (ToChildBlockJoinQuery)((Object)_other);
            return this.origParentQuery.equals((Object)other.origParentQuery) && this.parentsFilter.equals(other.parentsFilter) && this.doScores == other.doScores;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + new Boolean(this.doScores).hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    public Object clone() {
        return new ToChildBlockJoinQuery((Query)this.origParentQuery.clone(), this.parentsFilter, this.doScores);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final FixedBitSet parentBits;
        private final boolean doScores;
        private float parentScore;
        private int childDoc = -1;
        private int parentDoc;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, FixedBitSet parentBits, boolean doScores) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
        }

        public void visitSubScorers(Query parent, BooleanClause.Occur relationship, Scorer.ScorerVisitor<Query, Query, Scorer> visitor) {
            super.visitSubScorers(parent, relationship, visitor);
            this.parentScorer.visitScorers(visitor);
        }

        public int nextDoc() throws IOException {
            if (this.childDoc + 1 == this.parentDoc) {
                do {
                    this.parentDoc = this.parentScorer.nextDoc();
                    if (this.parentDoc == 0) {
                        this.parentDoc = this.parentScorer.nextDoc();
                    }
                    if (this.parentDoc == Integer.MAX_VALUE) {
                        this.childDoc = Integer.MAX_VALUE;
                        return this.childDoc;
                    }
                    this.childDoc = 1 + this.parentBits.prevSetBit(this.parentDoc - 1);
                } while (this.childDoc >= this.parentDoc);
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                }
                return this.childDoc;
            }
            assert (this.childDoc < this.parentDoc) : "childDoc=" + this.childDoc + " parentDoc=" + this.parentDoc;
            ++this.childDoc;
            return this.childDoc;
        }

        public int docID() {
            return this.childDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public int advance(int childTarget) throws IOException {
            assert (childTarget >= this.parentBits.length() || !this.parentBits.get(childTarget));
            if (childTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                this.childDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            assert (this.childDoc == -1 || childTarget != this.parentDoc) : "childTarget=" + childTarget;
            if (this.childDoc == -1 || childTarget > this.parentDoc) {
                this.parentDoc = this.parentScorer.advance(childTarget);
                assert (this.parentDoc > childTarget);
                if (this.parentDoc == Integer.MAX_VALUE) {
                    this.childDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                }
                int firstChild = this.parentBits.prevSetBit(this.parentDoc - 1);
                childTarget = Math.max(childTarget, firstChild);
            }
            assert (childTarget < this.parentDoc);
            this.childDoc = childTarget;
            return this.childDoc;
        }
    }

    private static class ToChildBlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight parentWeight;
        private final Filter parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, Filter parentsFilter, boolean doScores) {
            this.joinQuery = joinQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        public Query getQuery() {
            return this.joinQuery;
        }

        public float getValue() {
            return this.parentWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            return this.parentWeight.sumOfSquaredWeights() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        public void normalize(float norm) {
            this.parentWeight.normalize(norm * this.joinQuery.getBoost());
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(reader, true, false);
            if (parentScorer == null) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(reader);
            if (parents == null) {
                return null;
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
            }
            return new ToChildBlockJoinScorer(this, parentScorer, (FixedBitSet)parents, this.doScores);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot explain match on parent document");
        }

        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

