/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;

public class RawTermFilter
extends Filter {
    private final Term term;

    public RawTermFilter(Term term) {
        this.term = term;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (!(reader instanceof SegmentReader)) {
            throw new IllegalArgumentException("this filter can only work with SegmentReaders (got: " + reader + ")");
        }
        final SegmentReader segReader = (SegmentReader)reader;
        return new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                final TermDocs td = segReader.rawTermDocs(RawTermFilter.this.term);
                return new DocIdSetIterator(){
                    private int docID;

                    public int nextDoc() throws IOException {
                        this.docID = td.next() ? td.doc() : Integer.MAX_VALUE;
                        return this.docID;
                    }

                    public int docID() {
                        return this.docID;
                    }

                    public int advance(int target) throws IOException {
                        this.docID = td.skipTo(target) ? td.doc() : Integer.MAX_VALUE;
                        return this.docID;
                    }
                };
            }
        };
    }
}

