/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.dv;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public abstract class DVSecondPassGroupingCollector<GROUP_VALUE>
extends AbstractSecondPassGroupingCollector<GROUP_VALUE> {
    final String groupField;
    final DocValues.Type valueType;
    final boolean diskResident;

    public static <T> DVSecondPassGroupingCollector<T> create(String groupField, boolean diskResident, DocValues.Type type, Collection<SearchGroup<T>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        switch (type) {
            case VAR_INTS: 
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: {
                return new Lng(groupField, type, diskResident, (Collection<SearchGroup<Long>>)searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
            }
            case FLOAT_32: 
            case FLOAT_64: {
                return new Dbl(groupField, type, diskResident, (Collection<SearchGroup<Double>>)searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
            }
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_VAR_DEREF: {
                return new BR(groupField, type, diskResident, searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
            }
            case BYTES_VAR_SORTED: 
            case BYTES_FIXED_SORTED: {
                return new SortedBR(groupField, type, diskResident, searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
            }
        }
        throw new IllegalArgumentException(String.format("ValueType %s not supported", type));
    }

    DVSecondPassGroupingCollector(String groupField, DocValues.Type valueType, boolean diskResident, Collection<SearchGroup<GROUP_VALUE>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        super(searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        this.groupField = groupField;
        this.valueType = valueType;
        this.diskResident = diskResident;
    }

    @Override
    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        DocValues dv = readerContext.reader().docValues(this.groupField);
        DocValues.Source dvSource = dv != null ? (this.diskResident ? dv.getDirectSource() : dv.getSource()) : this.getDefaultSource(readerContext);
        this.setDocValuesSources(dvSource, readerContext);
    }

    protected abstract void setDocValuesSources(DocValues.Source var1, AtomicReaderContext var2);

    protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
        return DocValues.getDefaultSource((DocValues.Type)this.valueType);
    }

    static class SortedBR
    extends DVSecondPassGroupingCollector<BytesRef> {
        private DocValues.SortedSource source;
        private final BytesRef spare = new BytesRef();
        private final SentinelIntSet ordSet = new SentinelIntSet(this.groupMap.size(), -1);

        SortedBR(String groupField, DocValues.Type valueType, boolean diskResident, Collection<SearchGroup<BytesRef>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
            super(groupField, valueType, diskResident, searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
            this.groupDocs = new AbstractSecondPassGroupingCollector.SearchGroupDocs[this.ordSet.keys.length];
        }

        @Override
        protected AbstractSecondPassGroupingCollector.SearchGroupDocs<BytesRef> retrieveGroup(int doc) throws IOException {
            int slot = this.ordSet.find(this.source.ord(doc));
            if (slot >= 0) {
                return this.groupDocs[slot];
            }
            return null;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source.asSortedSource();
            this.ordSet.clear();
            for (AbstractSecondPassGroupingCollector.SearchGroupDocs group : this.groupMap.values()) {
                int ord = this.source.getOrdByValue((BytesRef)group.groupValue, this.spare);
                if (ord < 0) continue;
                this.groupDocs[this.ordSet.put((int)ord)] = group;
            }
        }

        @Override
        protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
            return DocValues.getDefaultSortedSource((DocValues.Type)this.valueType, (int)readerContext.reader().maxDoc());
        }
    }

    static class BR
    extends DVSecondPassGroupingCollector<BytesRef> {
        private DocValues.Source source;
        private final BytesRef spare = new BytesRef();

        BR(String groupField, DocValues.Type valueType, boolean diskResident, Collection<SearchGroup<BytesRef>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
            super(groupField, valueType, diskResident, searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        }

        @Override
        protected AbstractSecondPassGroupingCollector.SearchGroupDocs<BytesRef> retrieveGroup(int doc) throws IOException {
            return (AbstractSecondPassGroupingCollector.SearchGroupDocs)this.groupMap.get(this.source.getBytes(doc, this.spare));
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source;
        }
    }

    static class Dbl
    extends DVSecondPassGroupingCollector<Double> {
        private DocValues.Source source;

        Dbl(String groupField, DocValues.Type valueType, boolean diskResident, Collection<SearchGroup<Double>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
            super(groupField, valueType, diskResident, searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        }

        @Override
        protected AbstractSecondPassGroupingCollector.SearchGroupDocs<Double> retrieveGroup(int doc) throws IOException {
            return (AbstractSecondPassGroupingCollector.SearchGroupDocs)this.groupMap.get(this.source.getFloat(doc));
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source;
        }
    }

    static class Lng
    extends DVSecondPassGroupingCollector<Long> {
        private DocValues.Source source;

        Lng(String groupField, DocValues.Type valueType, boolean diskResident, Collection<SearchGroup<Long>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
            super(groupField, valueType, diskResident, searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields);
        }

        @Override
        protected AbstractSecondPassGroupingCollector.SearchGroupDocs<Long> retrieveGroup(int doc) throws IOException {
            return (AbstractSecondPassGroupingCollector.SearchGroupDocs)this.groupMap.get(this.source.getInt(doc));
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source;
        }
    }
}

