/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.SearchGroupDocs;
import org.apache.lucene.search.grouping.SentinelIntSet;
import org.apache.lucene.search.grouping.TopGroups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondPassGroupingCollector
extends Collector {
    private final HashMap<String, SearchGroupDocs> groupMap;
    private FieldCache.StringIndex index;
    private final String groupField;
    private final int maxDocsPerGroup;
    private final SentinelIntSet ordSet;
    private final SearchGroupDocs[] groupDocs;
    private final Collection<SearchGroup> groups;
    private final Sort withinGroupSort;
    private final Sort groupSort;
    private int totalHitCount;
    private int totalGroupedHitCount;

    public SecondPassGroupingCollector(String groupField, Collection<SearchGroup> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        if (groups.size() == 0) {
            throw new IllegalArgumentException("no groups to collect (groups.size() is 0)");
        }
        this.groupSort = groupSort;
        this.withinGroupSort = withinGroupSort;
        this.groups = groups;
        this.groupField = groupField;
        this.maxDocsPerGroup = maxDocsPerGroup;
        this.groupMap = new HashMap(groups.size());
        for (SearchGroup group : groups) {
            Object collector = withinGroupSort == null ? TopScoreDocCollector.create((int)maxDocsPerGroup, (boolean)true) : TopFieldCollector.create((Sort)withinGroupSort, (int)maxDocsPerGroup, (boolean)fillSortFields, (boolean)getScores, (boolean)getMaxScores, (boolean)true);
            this.groupMap.put(group.groupValue, new SearchGroupDocs(group.groupValue, (TopDocsCollector)collector));
        }
        this.ordSet = new SentinelIntSet(this.groupMap.size(), -1);
        this.groupDocs = new SearchGroupDocs[this.ordSet.keys.length];
    }

    public void setScorer(Scorer scorer) throws IOException {
        for (SearchGroupDocs group : this.groupMap.values()) {
            group.collector.setScorer(scorer);
        }
    }

    public void collect(int doc) throws IOException {
        int slot = this.ordSet.find(this.index.order[doc]);
        ++this.totalHitCount;
        if (slot >= 0) {
            ++this.totalGroupedHitCount;
            this.groupDocs[slot].collector.collect(doc);
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        for (SearchGroupDocs group : this.groupMap.values()) {
            group.collector.setNextReader(reader, docBase);
        }
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
        this.ordSet.clear();
        for (SearchGroupDocs group : this.groupMap.values()) {
            int ord = group.groupValue == null ? 0 : this.index.binarySearchLookup(group.groupValue);
            if (ord < 0) continue;
            this.groupDocs[this.ordSet.put((int)ord)] = group;
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public TopGroups getTopGroups(int withinGroupOffset) {
        GroupDocs[] groupDocsResult = new GroupDocs[this.groups.size()];
        int groupIDX = 0;
        for (SearchGroup group : this.groups) {
            SearchGroupDocs groupDocs = this.groupMap.get(group.groupValue);
            TopDocs topDocs = groupDocs.collector.topDocs(withinGroupOffset, this.maxDocsPerGroup);
            groupDocsResult[groupIDX++] = new GroupDocs(topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, groupDocs.groupValue, group.sortValues);
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort == null ? null : this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsResult);
    }
}

