/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.IndexableBinaryStringTools;

public final class ICUCollationKeyFilter
extends TokenFilter {
    private Collator collator = null;
    private RawCollationKey reusableKey = new RawCollationKey();
    private TermAttribute termAtt;

    public ICUCollationKeyFilter(TokenStream input, Collator collator) {
        super(input);
        this.collator = collator;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.termBuffer();
            String termText = new String(termBuffer, 0, this.termAtt.termLength());
            this.collator.getRawCollationKey(termText, this.reusableKey);
            ByteBuffer collationKeyBuf = ByteBuffer.wrap(this.reusableKey.bytes, 0, this.reusableKey.size);
            int encodedLength = IndexableBinaryStringTools.getEncodedLength((ByteBuffer)collationKeyBuf);
            if (encodedLength > termBuffer.length) {
                this.termAtt.resizeTermBuffer(encodedLength);
            }
            this.termAtt.setTermLength(encodedLength);
            CharBuffer wrappedTermBuffer = CharBuffer.wrap(this.termAtt.termBuffer());
            IndexableBinaryStringTools.encode((ByteBuffer)collationKeyBuf, (CharBuffer)wrappedTermBuffer);
            return true;
        }
        return false;
    }
}

