/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

class SimpleTextDocValuesReader
extends DocValuesProducer {
    final int maxDoc;
    final IndexInput data;
    final BytesRefBuilder scratch;
    final Map<String, OneField> fields;

    public SimpleTextDocValuesReader(SegmentReadState state, String ext) throws IOException {
        block15: {
            this.scratch = new BytesRefBuilder();
            this.fields = new HashMap<String, OneField>();
            this.data = state.directory.openInput(IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)ext), state.context);
            this.maxDoc = state.segmentInfo.maxDoc();
            while (true) {
                this.readLine();
                if (this.scratch.get().equals((Object)SimpleTextDocValuesWriter.END)) break block15;
                assert (this.startsWith(SimpleTextDocValuesWriter.FIELD)) : this.scratch.get().utf8ToString();
                String fieldName = this.stripPrefix(SimpleTextDocValuesWriter.FIELD);
                OneField field = new OneField();
                this.fields.put(fieldName, field);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.TYPE)) : this.scratch.get().utf8ToString();
                DocValuesType dvType = DocValuesType.valueOf((String)this.stripPrefix(SimpleTextDocValuesWriter.TYPE));
                assert (dvType != DocValuesType.NONE);
                if (dvType == DocValuesType.NUMERIC) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MINVALUE)) : "got " + this.scratch.get().utf8ToString() + " field=" + fieldName + " ext=" + ext;
                    field.minValue = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.MINVALUE));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)(1 + field.pattern.length() + 2) * (long)this.maxDoc);
                    continue;
                }
                if (dvType == DocValuesType.BINARY) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                    field.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)(9 + field.pattern.length() + field.maxLength + 2) * (long)this.maxDoc);
                    continue;
                }
                if (dvType != DocValuesType.SORTED && dvType != DocValuesType.SORTED_SET) break;
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.NUMVALUES));
                field.numValues = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.NUMVALUES));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                field.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.ORDPATTERN));
                field.ordPattern = this.stripPrefix(SimpleTextDocValuesWriter.ORDPATTERN);
                field.dataStartFilePointer = this.data.getFilePointer();
                this.data.seek(this.data.getFilePointer() + (long)(9 + field.pattern.length() + field.maxLength) * field.numValues + (long)(1 + field.ordPattern.length()) * (long)this.maxDoc);
            }
            throw new AssertionError();
        }
        assert (!this.fields.isEmpty());
    }

    public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
        final IntFunction<Long> values = this.getNumericNonIterator(fieldInfo);
        if (values == null) {
            return null;
        }
        final DocValuesIterator docsWithField = this.getNumericDocsWithField(fieldInfo);
        return new NumericDocValues(){

            public int nextDoc() throws IOException {
                return docsWithField.nextDoc();
            }

            public int docID() {
                return docsWithField.docID();
            }

            public long cost() {
                return docsWithField.cost();
            }

            public int advance(int target) throws IOException {
                return docsWithField.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                return docsWithField.advanceExact(target);
            }

            public long longValue() throws IOException {
                return (Long)values.apply(docsWithField.docID());
            }
        };
    }

    IntFunction<Long> getNumericNonIterator(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        assert (field != null) : "field=" + fieldInfo.name + " fields=" + String.valueOf(this.fields);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        decoder.setParseBigDecimal(true);
        return new IntFunction<Long>(){

            @Override
            public Long apply(int docID) {
                try {
                    BigDecimal bd;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field.dataStartFilePointer + (long)(1 + field.pattern.length() + 2) * (long)docID);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    try {
                        bd = (BigDecimal)decoder.parse(scratch.get().utf8ToString());
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse BigDecimal value", (DataInput)in, (Throwable)pe);
                    }
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    return BigInteger.valueOf(field.minValue).add(bd.toBigIntegerExact()).longValue();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private DocValuesIterator getNumericDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        return new DocValuesIterator(){
            int doc = -1;

            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            public int docID() {
                return this.doc;
            }

            public long cost() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }

            public int advance(int target) throws IOException {
                for (int i = target; i < SimpleTextDocValuesReader.this.maxDoc; ++i) {
                    in.seek(field.dataStartFilePointer + (long)(1 + field.pattern.length() + 2) * (long)i);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    if (scratch.byteAt(0) != 84) continue;
                    this.doc = i;
                    return this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            boolean advanceExact(int target) throws IOException {
                this.doc = target;
                in.seek(field.dataStartFilePointer + (long)(1 + field.pattern.length() + 2) * (long)target);
                SimpleTextUtil.readLine((DataInput)in, scratch);
                SimpleTextUtil.readLine((DataInput)in, scratch);
                return scratch.byteAt(0) == 84;
            }
        };
    }

    public synchronized BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        final DocValuesIterator docsWithField = this.getBinaryDocsWithField(fieldInfo);
        final IntFunction<BytesRef> values = new IntFunction<BytesRef>(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public BytesRef apply(int docID) {
                try {
                    int len;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field.dataStartFilePointer + (long)(9 + field.pattern.length() + field.maxLength + 2) * (long)docID);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length", (DataInput)in, (Throwable)pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
        return new BinaryDocValues(){

            public int nextDoc() throws IOException {
                return docsWithField.nextDoc();
            }

            public int docID() {
                return docsWithField.docID();
            }

            public long cost() {
                return docsWithField.cost();
            }

            public int advance(int target) throws IOException {
                return docsWithField.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                return docsWithField.advanceExact(target);
            }

            public BytesRef binaryValue() throws IOException {
                return (BytesRef)values.apply(docsWithField.docID());
            }
        };
    }

    private DocValuesIterator getBinaryDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new DocValuesIterator(){
            int doc = -1;

            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            public int docID() {
                return this.doc;
            }

            public long cost() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }

            public int advance(int target) throws IOException {
                for (int i = target; i < SimpleTextDocValuesReader.this.maxDoc; ++i) {
                    int len;
                    in.seek(field.dataStartFilePointer + (long)(9 + field.pattern.length() + field.maxLength + 2) * (long)i);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length", (DataInput)in, (Throwable)pe);
                    }
                    byte[] bytes = new byte[len];
                    in.readBytes(bytes, 0, len);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    if (scratch.byteAt(0) != 84) continue;
                    this.doc = i;
                    return this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            boolean advanceExact(int target) throws IOException {
                int len;
                this.doc = target;
                in.seek(field.dataStartFilePointer + (long)(9 + field.pattern.length() + field.maxLength + 2) * (long)target);
                SimpleTextUtil.readLine((DataInput)in, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SimpleTextDocValuesWriter.LENGTH));
                try {
                    len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                }
                catch (ParseException pe) {
                    throw new CorruptIndexException("failed to parse int length", (DataInput)in, (Throwable)pe);
                }
                byte[] bytes = new byte[len];
                in.readBytes(bytes, 0, len);
                SimpleTextUtil.readLine((DataInput)in, scratch);
                SimpleTextUtil.readLine((DataInput)in, scratch);
                return scratch.byteAt(0) == 84;
            }
        };
    }

    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        final DecimalFormat ordDecoder = new DecimalFormat(field.ordPattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedDocValues(){
            int doc = -1;
            int ord;
            final BytesRefBuilder term = new BytesRefBuilder();

            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            public int docID() {
                return this.doc;
            }

            public long cost() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }

            public int advance(int target) throws IOException {
                for (int i = target; i < SimpleTextDocValuesReader.this.maxDoc; ++i) {
                    in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)i * (long)(1 + field.ordPattern.length()));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    try {
                        this.ord = (int)ordDecoder.parse(scratch.get().utf8ToString()).longValue() - 1;
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse ord", (DataInput)in, (Throwable)pe);
                    }
                    if (this.ord < 0) continue;
                    this.doc = i;
                    return this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)target * (long)(1 + field.ordPattern.length()));
                SimpleTextUtil.readLine((DataInput)in, scratch);
                try {
                    this.ord = (int)ordDecoder.parse(scratch.get().utf8ToString()).longValue() - 1;
                }
                catch (ParseException pe) {
                    throw new CorruptIndexException("failed to parse ord", (DataInput)in, (Throwable)pe);
                }
                return this.ord >= 0;
            }

            public int ordValue() {
                return this.ord;
            }

            public BytesRef lookupOrd(int ord) throws IOException {
                int len;
                if (ord < 0 || (long)ord >= field.numValues) {
                    throw new IndexOutOfBoundsException("ord must be 0 .. " + (field.numValues - 1L) + "; got " + ord);
                }
                in.seek(field.dataStartFilePointer + (long)ord * (long)(9 + field.pattern.length() + field.maxLength));
                SimpleTextUtil.readLine((DataInput)in, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.get().utf8ToString() + " in=" + String.valueOf(in);
                try {
                    len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                }
                catch (ParseException pe) {
                    throw new CorruptIndexException("failed to parse int length", (DataInput)in, (Throwable)pe);
                }
                this.term.grow(len);
                this.term.setLength(len);
                in.readBytes(this.term.bytes(), 0, len);
                return this.term.get();
            }

            public int getValueCount() {
                return (int)field.numValues;
            }
        };
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        final BinaryDocValues binary = this.getBinary(field);
        return new SortedNumericDocValues(){
            long[] values;
            int index;

            public int nextDoc() throws IOException {
                int doc = binary.nextDoc();
                this.setCurrentDoc();
                return doc;
            }

            public int docID() {
                return binary.docID();
            }

            public long cost() {
                return binary.cost();
            }

            public int advance(int target) throws IOException {
                int doc = binary.advance(target);
                this.setCurrentDoc();
                return doc;
            }

            public boolean advanceExact(int target) throws IOException {
                if (binary.advanceExact(target)) {
                    this.setCurrentDoc();
                    return true;
                }
                return false;
            }

            private void setCurrentDoc() throws IOException {
                if (this.docID() == Integer.MAX_VALUE) {
                    return;
                }
                String csv = binary.binaryValue().utf8ToString();
                if (csv.length() == 0) {
                    this.values = new long[0];
                } else {
                    String[] s = csv.split(",");
                    this.values = new long[s.length];
                    for (int i = 0; i < this.values.length; ++i) {
                        this.values[i] = Long.parseLong(s[i]);
                    }
                }
                this.index = 0;
            }

            public long nextValue() throws IOException {
                return this.values[this.index++];
            }

            public int docValueCount() {
                return this.values.length;
            }
        };
    }

    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedSetDocValues(){
            String[] currentOrds = new String[0];
            int currentIndex = 0;
            final BytesRefBuilder term = new BytesRefBuilder();
            int doc = -1;

            public int nextDoc() throws IOException {
                return this.advance(this.doc + 1);
            }

            public int docID() {
                return this.doc;
            }

            public long cost() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }

            public int advance(int target) throws IOException {
                for (int i = target; i < SimpleTextDocValuesReader.this.maxDoc; ++i) {
                    in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)i * (long)(1 + field.ordPattern.length()));
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    String ordList = scratch.get().utf8ToString().trim();
                    if (ordList.isEmpty()) continue;
                    this.currentOrds = ordList.split(",");
                    this.currentIndex = 0;
                    this.doc = i;
                    return this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public boolean advanceExact(int target) throws IOException {
                in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)target * (long)(1 + field.ordPattern.length()));
                SimpleTextUtil.readLine((DataInput)in, scratch);
                String ordList = scratch.get().utf8ToString().trim();
                this.doc = target;
                if (!ordList.isEmpty()) {
                    this.currentOrds = ordList.split(",");
                    this.currentIndex = 0;
                    return true;
                }
                return false;
            }

            public long nextOrd() throws IOException {
                if (this.currentIndex == this.currentOrds.length) {
                    return -1L;
                }
                return Long.parseLong(this.currentOrds[this.currentIndex++]);
            }

            public int docValueCount() {
                return this.currentOrds.length;
            }

            public BytesRef lookupOrd(long ord) throws IOException {
                int len;
                if (ord < 0L || ord >= field.numValues) {
                    throw new IndexOutOfBoundsException("ord must be 0 .. " + (field.numValues - 1L) + "; got " + ord);
                }
                in.seek(field.dataStartFilePointer + ord * (long)(9 + field.pattern.length() + field.maxLength));
                SimpleTextUtil.readLine((DataInput)in, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.get().utf8ToString() + " in=" + String.valueOf(in);
                try {
                    len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                }
                catch (ParseException pe) {
                    throw new CorruptIndexException("failed to parse int length", (DataInput)in, (Throwable)pe);
                }
                this.term.grow(len);
                this.term.setLength(len);
                in.readBytes(this.term.bytes(), 0, len);
                return this.term.get();
            }

            public long getValueCount() {
                return field.numValues;
            }
        };
    }

    public void close() throws IOException {
        this.data.close();
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine((DataInput)this.data, this.scratch);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)prefix);
    }

    private String stripPrefix(BytesRef prefix) {
        return new String(this.scratch.bytes(), prefix.length, this.scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    public void checkIntegrity() throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        IndexInput clone = this.data.clone();
        clone.seek(0L);
        long footerStartPos = this.data.length() - (long)(SimpleTextUtil.CHECKSUM.length + 21);
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(clone);
        do {
            SimpleTextUtil.readLine((DataInput)input, scratch);
        } while (input.getFilePointer() < footerStartPos);
        if (input.getFilePointer() != footerStartPos) {
            throw new CorruptIndexException("SimpleText failure: footer does not start at expected position current=" + input.getFilePointer() + " vs expected=" + footerStartPos, (DataInput)input);
        }
        SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
    }

    static class OneField {
        long dataStartFilePointer;
        String pattern;
        String ordPattern;
        int maxLength;
        boolean fixedLength;
        long minValue;
        long numValues;

        OneField() {
        }
    }

    private static abstract class DocValuesIterator
    extends DocIdSetIterator {
        private DocValuesIterator() {
        }

        abstract boolean advanceExact(int var1) throws IOException;
    }
}

