/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockHeader
implements Accountable {
    private static final long RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BlockHeader.class);
    protected int linesCount;
    protected long baseDocsFP;
    protected long basePositionsFP;
    protected long basePayloadsFP;
    protected int termStatesBaseOffset;
    protected int middleLineIndex;
    protected int middleLineOffset;

    protected BlockHeader(int linesCount, long baseDocsFP, long basePositionsFP, long basePayloadsFP, int termStatesBaseOffset, int middleLineOffset) {
        this.reset(linesCount, baseDocsFP, basePositionsFP, basePayloadsFP, termStatesBaseOffset, middleLineOffset);
    }

    protected BlockHeader() {
    }

    protected BlockHeader reset(int linesCount, long baseDocsFP, long basePositionsFP, long basePayloadsFP, int termStatesBaseOffset, int middleTermOffset) {
        this.baseDocsFP = baseDocsFP;
        this.basePositionsFP = basePositionsFP;
        this.basePayloadsFP = basePayloadsFP;
        this.linesCount = linesCount;
        this.middleLineIndex = linesCount >> 1;
        this.termStatesBaseOffset = termStatesBaseOffset;
        this.middleLineOffset = middleTermOffset;
        return this;
    }

    public int getLinesCount() {
        return this.linesCount;
    }

    public int getMiddleLineIndex() {
        return this.middleLineIndex;
    }

    public int getMiddleLineOffset() {
        return this.middleLineOffset;
    }

    public int getTermStatesBaseOffset() {
        return this.termStatesBaseOffset;
    }

    public long getBaseDocsFP() {
        return this.baseDocsFP;
    }

    public long getBasePositionsFP() {
        return this.basePositionsFP;
    }

    public long getBasePayloadsFP() {
        return this.basePayloadsFP;
    }

    public void write(DataOutput output) throws IOException {
        assert (this.linesCount > 0) : "block header does not seem to be initialized";
        output.writeVInt(this.linesCount);
        output.writeVLong(this.baseDocsFP);
        output.writeVLong(this.basePositionsFP);
        output.writeVLong(this.basePayloadsFP);
        output.writeVInt(this.termStatesBaseOffset);
        output.writeVInt(this.middleLineOffset);
    }

    public static BlockHeader read(DataInput input, BlockHeader reuse) throws IOException {
        int linesCount = input.readVInt();
        assert (linesCount > 0 && linesCount <= 1000) : "linesCount=" + linesCount;
        long baseDocsFP = input.readVLong();
        long basePositionsFP = input.readVLong();
        long basePayloadsFP = input.readVLong();
        int termStatesBaseOffset = input.readVInt();
        int middleTermOffset = input.readVInt();
        BlockHeader blockHeader = reuse == null ? new BlockHeader() : reuse;
        return blockHeader.reset(linesCount, baseDocsFP, basePositionsFP, basePayloadsFP, termStatesBaseOffset, middleTermOffset);
    }

    public long ramBytesUsed() {
        return RAM_USAGE;
    }
}

