/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.codecs.simpletext.SimpleTextPointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.bkd.BKDReader;

class SimpleTextBKDReader
extends BKDReader {
    public SimpleTextBKDReader(IndexInput datIn, int numDims, int maxPointsInLeafNode, int bytesPerDim, long[] leafBlockFPs, byte[] splitPackedValues, byte[] minPackedValue, byte[] maxPackedValue, long pointCount, int docCount) throws IOException {
        super(datIn, numDims, maxPointsInLeafNode, bytesPerDim, leafBlockFPs, splitPackedValues, minPackedValue, maxPackedValue, pointCount, docCount);
    }

    protected void visitDocIDs(IndexInput in, long blockFP, PointValues.IntersectVisitor visitor) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        in.seek(blockFP);
        this.readLine(in, scratch);
        int count = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_COUNT);
        for (int i = 0; i < count; ++i) {
            this.readLine(in, scratch);
            visitor.visit(this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_DOC_ID));
        }
    }

    protected int readDocIDs(IndexInput in, long blockFP, int[] docIDs) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        in.seek(blockFP);
        this.readLine(in, scratch);
        int count = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_COUNT);
        for (int i = 0; i < count; ++i) {
            this.readLine(in, scratch);
            docIDs[i] = this.parseInt(scratch, SimpleTextPointsWriter.BLOCK_DOC_ID);
        }
        return count;
    }

    protected void visitDocValues(int[] commonPrefixLengths, byte[] scratchPackedValue, IndexInput in, int[] docIDs, int count, PointValues.IntersectVisitor visitor) throws IOException {
        assert (scratchPackedValue.length == this.packedBytesLength);
        BytesRefBuilder scratch = new BytesRefBuilder();
        for (int i = 0; i < count; ++i) {
            this.readLine(in, scratch);
            assert (this.startsWith(scratch, SimpleTextPointsWriter.BLOCK_VALUE));
            BytesRef br = SimpleTextUtil.fromBytesRefString(this.stripPrefix(scratch, SimpleTextPointsWriter.BLOCK_VALUE));
            assert (br.length == this.packedBytesLength);
            System.arraycopy(br.bytes, br.offset, scratchPackedValue, 0, this.packedBytesLength);
            visitor.visit(docIDs[i], scratchPackedValue);
        }
    }

    private int parseInt(BytesRefBuilder scratch, BytesRef prefix) {
        assert (this.startsWith(scratch, prefix));
        return Integer.parseInt(this.stripPrefix(scratch, prefix));
    }

    private String stripPrefix(BytesRefBuilder scratch, BytesRef prefix) {
        return new String(scratch.bytes(), prefix.length, scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    private boolean startsWith(BytesRefBuilder scratch, BytesRef prefix) {
        return StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)prefix);
    }

    private void readLine(IndexInput in, BytesRefBuilder scratch) throws IOException {
        SimpleTextUtil.readLine((DataInput)in, scratch);
    }
}

