/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class SimpleTextFieldsWriter
extends FieldsConsumer {
    private IndexOutput out;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final SegmentWriteState writeState;
    static final BytesRef END = new BytesRef((CharSequence)"END");
    static final BytesRef FIELD = new BytesRef((CharSequence)"field ");
    static final BytesRef TERM = new BytesRef((CharSequence)"  term ");
    static final BytesRef DOC = new BytesRef((CharSequence)"    doc ");
    static final BytesRef FREQ = new BytesRef((CharSequence)"      freq ");
    static final BytesRef POS = new BytesRef((CharSequence)"      pos ");
    static final BytesRef START_OFFSET = new BytesRef((CharSequence)"      startOffset ");
    static final BytesRef END_OFFSET = new BytesRef((CharSequence)"      endOffset ");
    static final BytesRef PAYLOAD = new BytesRef((CharSequence)"        payload ");

    public SimpleTextFieldsWriter(SegmentWriteState writeState) throws IOException {
        String fileName = SimpleTextPostingsFormat.getPostingsFileName(writeState.segmentInfo.name, writeState.segmentSuffix);
        this.out = writeState.directory.createOutput(fileName, writeState.context);
        this.writeState = writeState;
    }

    public void write(Fields fields) throws IOException {
        this.write(this.writeState.fieldInfos, fields);
    }

    public void write(FieldInfos fieldInfos, Fields fields) throws IOException {
        for (String field : fields) {
            BytesRef term;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
            boolean wroteField = false;
            boolean hasPositions = terms.hasPositions();
            boolean hasFreqs = terms.hasFreqs();
            boolean hasPayloads = fieldInfo.hasPayloads();
            boolean hasOffsets = terms.hasOffsets();
            int flags = 0;
            if (hasPositions) {
                if (hasPayloads) {
                    flags |= 2;
                }
                if (hasOffsets) {
                    flags |= 1;
                }
            } else if (hasFreqs) {
                flags |= 1;
            }
            TermsEnum termsEnum = terms.iterator(null);
            DocsAndPositionsEnum posEnum = null;
            DocsEnum docsEnum = null;
            while ((term = termsEnum.next()) != null) {
                int doc;
                if (hasPositions) {
                    posEnum = termsEnum.docsAndPositions(null, posEnum, flags);
                    docsEnum = posEnum;
                } else {
                    docsEnum = termsEnum.docs(null, docsEnum, flags);
                }
                assert (docsEnum != null) : "termsEnum=" + termsEnum + " hasPos=" + hasPositions + " flags=" + flags;
                boolean wroteTerm = false;
                while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    if (!wroteTerm) {
                        if (!wroteField) {
                            this.write(FIELD);
                            this.write(field);
                            this.newline();
                            wroteField = true;
                        }
                        this.write(TERM);
                        this.write(term);
                        this.newline();
                        wroteTerm = true;
                    }
                    this.write(DOC);
                    this.write(Integer.toString(doc));
                    this.newline();
                    if (!hasFreqs) continue;
                    int freq = docsEnum.freq();
                    this.write(FREQ);
                    this.write(Integer.toString(freq));
                    this.newline();
                    if (!hasPositions) continue;
                    int lastStartOffset = 0;
                    for (int i = 0; i < freq; ++i) {
                        BytesRef payload;
                        int position = posEnum.nextPosition();
                        this.write(POS);
                        this.write(Integer.toString(position));
                        this.newline();
                        if (hasOffsets) {
                            int startOffset = posEnum.startOffset();
                            int endOffset = posEnum.endOffset();
                            assert (endOffset >= startOffset);
                            assert (startOffset >= lastStartOffset) : "startOffset=" + startOffset + " lastStartOffset=" + lastStartOffset;
                            lastStartOffset = startOffset;
                            this.write(START_OFFSET);
                            this.write(Integer.toString(startOffset));
                            this.newline();
                            this.write(END_OFFSET);
                            this.write(Integer.toString(endOffset));
                            this.newline();
                        }
                        if ((payload = posEnum.getPayload()) == null || payload.length <= 0) continue;
                        assert (payload.length != 0);
                        this.write(PAYLOAD);
                        this.write(payload);
                        this.newline();
                    }
                }
            }
        }
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write((DataOutput)this.out, s, this.scratch);
    }

    private void write(BytesRef b) throws IOException {
        SimpleTextUtil.write((DataOutput)this.out, b);
    }

    private void newline() throws IOException {
        SimpleTextUtil.writeNewline((DataOutput)this.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.write(END);
                this.newline();
                SimpleTextUtil.writeChecksum(this.out, this.scratch);
            }
            finally {
                this.out.close();
                this.out = null;
            }
        }
    }
}

