/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

class DirectDocValuesProducer
extends DocValuesProducer {
    private final Map<Integer, NumericEntry> numerics;
    private final Map<Integer, BinaryEntry> binaries;
    private final Map<Integer, SortedEntry> sorteds;
    private final Map<Integer, SortedSetEntry> sortedSets;
    private final Map<Integer, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final Map<Integer, NumericDocValues> numericInstances;
    private final Map<Integer, BinaryRawValues> binaryInstances;
    private final Map<Integer, SortedRawValues> sortedInstances;
    private final Map<Integer, SortedSetRawValues> sortedSetInstances;
    private final Map<Integer, SortedNumericRawValues> sortedNumericInstances;
    private final Map<Integer, Bits> docsWithFieldInstances;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final int version;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte SORTED = 2;
    static final byte SORTED_SET = 3;
    static final byte SORTED_SET_SINGLETON = 4;
    static final byte SORTED_NUMERIC = 5;
    static final byte SORTED_NUMERIC_SINGLETON = 6;
    static final int VERSION_START = 2;
    static final int VERSION_CURRENT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block8: {
            ChecksumIndexInput in;
            block7: {
                this.numerics = new HashMap<Integer, NumericEntry>();
                this.binaries = new HashMap<Integer, BinaryEntry>();
                this.sorteds = new HashMap<Integer, SortedEntry>();
                this.sortedSets = new HashMap<Integer, SortedSetEntry>();
                this.sortedNumerics = new HashMap<Integer, SortedNumericEntry>();
                this.numericInstances = new HashMap<Integer, NumericDocValues>();
                this.binaryInstances = new HashMap<Integer, BinaryRawValues>();
                this.sortedInstances = new HashMap<Integer, SortedRawValues>();
                this.sortedSetInstances = new HashMap<Integer, SortedSetRawValues>();
                this.sortedNumericInstances = new HashMap<Integer, SortedNumericRawValues>();
                this.docsWithFieldInstances = new HashMap<Integer, Bits>();
                this.maxDoc = state.segmentInfo.getDocCount();
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
                in = state.directory.openChecksumInput(metaName, state.context);
                this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
                success = false;
                try {
                    this.version = CodecUtil.checkHeader((DataInput)in, (String)metaCodec, (int)2, (int)2);
                    this.readFields((IndexInput)in);
                    CodecUtil.checkFooter((ChecksumIndexInput)in);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block8;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkHeader((DataInput)this.data, (String)dataCodec, (int)2, (int)2);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch");
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.offset = meta.readLong();
        entry.count = meta.readInt();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.byteWidth = meta.readByte();
        return entry;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.offset = meta.readLong();
        entry.numBytes = meta.readInt();
        entry.count = meta.readInt();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        return entry;
    }

    private SortedEntry readSortedEntry(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.docToOrd = this.readNumericEntry(meta);
        entry.values = this.readBinaryEntry(meta);
        return entry;
    }

    private SortedSetEntry readSortedSetEntry(IndexInput meta, boolean singleton) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        if (!singleton) {
            entry.docToOrdAddress = this.readNumericEntry(meta);
        }
        entry.ords = this.readNumericEntry(meta);
        entry.values = this.readBinaryEntry(meta);
        return entry;
    }

    private SortedNumericEntry readSortedNumericEntry(IndexInput meta, boolean singleton) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        if (!singleton) {
            entry.docToAddress = this.readNumericEntry(meta);
        }
        entry.values = this.readNumericEntry(meta);
        return entry;
    }

    private void readFields(IndexInput meta) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(fieldNumber, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(fieldNumber, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                entry = this.readSortedEntry(meta);
                this.sorteds.put(fieldNumber, (SortedEntry)entry);
                this.binaries.put(fieldNumber, ((SortedEntry)entry).values);
            } else if (fieldType == 3) {
                entry = this.readSortedSetEntry(meta, false);
                this.sortedSets.put(fieldNumber, (SortedSetEntry)entry);
                this.binaries.put(fieldNumber, ((SortedSetEntry)entry).values);
            } else if (fieldType == 4) {
                entry = this.readSortedSetEntry(meta, true);
                this.sortedSets.put(fieldNumber, (SortedSetEntry)entry);
                this.binaries.put(fieldNumber, ((SortedSetEntry)entry).values);
            } else if (fieldType == 5) {
                entry = this.readSortedNumericEntry(meta, false);
                this.sortedNumerics.put(fieldNumber, (SortedNumericEntry)entry);
            } else if (fieldType == 6) {
                entry = this.readSortedNumericEntry(meta, true);
                this.sortedNumerics.put(fieldNumber, (SortedNumericEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", input=" + meta);
            }
            fieldNumber = meta.readVInt();
        }
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field.number);
        if (instance == null) {
            instance = this.loadNumeric(this.numerics.get(field.number));
            this.numericInstances.put(field.number, instance);
        }
        return instance;
    }

    private NumericDocValues loadNumeric(NumericEntry entry) throws IOException {
        this.data.seek(entry.offset + entry.missingBytes);
        switch (entry.byteWidth) {
            case 1: {
                final byte[] values = new byte[entry.count];
                this.data.readBytes(values, 0, entry.count);
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((byte[])values));
                return new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
            case 2: {
                final short[] values = new short[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readShort();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((short[])values));
                return new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
            case 4: {
                final int[] values = new int[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readInt();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((int[])values));
                return new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
            case 8: {
                final long[] values = new long[entry.count];
                for (int i = 0; i < entry.count; ++i) {
                    values[i] = this.data.readLong();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((long[])values));
                return new NumericDocValues(){

                    public long get(int idx) {
                        return values[idx];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryRawValues instance = this.binaryInstances.get(field.number);
        if (instance == null) {
            instance = this.loadBinary(this.binaries.get(field.number));
            this.binaryInstances.put(field.number, instance);
        }
        final byte[] bytes = instance.bytes;
        final int[] address = instance.address;
        return new BinaryDocValues(){
            final BytesRef term = new BytesRef();

            public BytesRef get(int docID) {
                this.term.bytes = bytes;
                this.term.offset = address[docID];
                this.term.length = address[docID + 1] - this.term.offset;
                return this.term;
            }
        };
    }

    private BinaryRawValues loadBinary(BinaryEntry entry) throws IOException {
        this.data.seek(entry.offset);
        byte[] bytes = new byte[entry.numBytes];
        this.data.readBytes(bytes, 0, entry.numBytes);
        this.data.seek(entry.offset + (long)entry.numBytes + entry.missingBytes);
        int[] address = new int[entry.count + 1];
        for (int i = 0; i < entry.count; ++i) {
            address[i] = this.data.readInt();
        }
        address[entry.count] = this.data.readInt();
        this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((byte[])bytes) + RamUsageEstimator.sizeOf((int[])address));
        BinaryRawValues values = new BinaryRawValues();
        values.bytes = bytes;
        values.address = address;
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedRawValues instance;
        SortedEntry entry = this.sorteds.get(field.number);
        DirectDocValuesProducer directDocValuesProducer = this;
        synchronized (directDocValuesProducer) {
            instance = this.sortedInstances.get(field.number);
            if (instance == null) {
                instance = this.loadSorted(field);
                this.sortedInstances.put(field.number, instance);
            }
        }
        return this.newSortedInstance(instance.docToOrd, this.getBinary(field), entry.values.count);
    }

    private SortedDocValues newSortedInstance(final NumericDocValues docToOrd, final BinaryDocValues values, final int count) {
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                return values.get(ord);
            }

            public int getValueCount() {
                return count;
            }
        };
    }

    private SortedRawValues loadSorted(FieldInfo field) throws IOException {
        SortedEntry entry = this.sorteds.get(field.number);
        NumericDocValues docToOrd = this.loadNumeric(entry.docToOrd);
        SortedRawValues values = new SortedRawValues();
        values.docToOrd = docToOrd;
        return values;
    }

    public synchronized SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericRawValues instance = this.sortedNumericInstances.get(field.number);
        SortedNumericEntry entry = this.sortedNumerics.get(field.number);
        if (instance == null) {
            instance = this.loadSortedNumeric(entry);
            this.sortedNumericInstances.put(field.number, instance);
        }
        if (entry.docToAddress == null) {
            NumericDocValues single = instance.values;
            Bits docsWithField = this.getMissingBits(field.number, entry.values.missingOffset, entry.values.missingBytes);
            return DocValues.singleton((NumericDocValues)single, (Bits)docsWithField);
        }
        final NumericDocValues docToAddress = instance.docToAddress;
        final NumericDocValues values = instance.values;
        return new SortedNumericDocValues(){
            int valueStart;
            int valueLimit;

            public void setDocument(int doc) {
                this.valueStart = (int)docToAddress.get(doc);
                this.valueLimit = (int)docToAddress.get(doc + 1);
            }

            public long valueAt(int index) {
                return values.get(this.valueStart + index);
            }

            public int count() {
                return this.valueLimit - this.valueStart;
            }
        };
    }

    private SortedNumericRawValues loadSortedNumeric(SortedNumericEntry entry) throws IOException {
        SortedNumericRawValues instance = new SortedNumericRawValues();
        if (entry.docToAddress != null) {
            instance.docToAddress = this.loadNumeric(entry.docToAddress);
        }
        instance.values = this.loadNumeric(entry.values);
        return instance;
    }

    public synchronized SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetRawValues instance = this.sortedSetInstances.get(field.number);
        final SortedSetEntry entry = this.sortedSets.get(field.number);
        if (instance == null) {
            instance = this.loadSortedSet(entry);
            this.sortedSetInstances.put(field.number, instance);
        }
        if (instance.docToOrdAddress == null) {
            SortedDocValues sorted = this.newSortedInstance(instance.ords, this.getBinary(field), entry.values.count);
            return DocValues.singleton((SortedDocValues)sorted);
        }
        final NumericDocValues docToOrdAddress = instance.docToOrdAddress;
        final NumericDocValues ords = instance.ords;
        final BinaryDocValues values = this.getBinary(field);
        return new RandomAccessOrds(){
            int ordStart;
            int ordUpto;
            int ordLimit;

            public long nextOrd() {
                if (this.ordUpto == this.ordLimit) {
                    return -1L;
                }
                return ords.get(this.ordUpto++);
            }

            public void setDocument(int docID) {
                this.ordStart = this.ordUpto = (int)docToOrdAddress.get(docID);
                this.ordLimit = (int)docToOrdAddress.get(docID + 1);
            }

            public BytesRef lookupOrd(long ord) {
                return values.get((int)ord);
            }

            public long getValueCount() {
                return entry.values.count;
            }

            public long ordAt(int index) {
                return ords.get(this.ordStart + index);
            }

            public int cardinality() {
                return this.ordLimit - this.ordStart;
            }
        };
    }

    private SortedSetRawValues loadSortedSet(SortedSetEntry entry) throws IOException {
        SortedSetRawValues instance = new SortedSetRawValues();
        if (entry.docToOrdAddress != null) {
            instance.docToOrdAddress = this.loadNumeric(entry.docToOrdAddress);
        }
        instance.ords = this.loadNumeric(entry.ords);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(int fieldNumber, long offset, long length) throws IOException {
        Bits instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        DirectDocValuesProducer directDocValuesProducer = this;
        synchronized (directDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(fieldNumber);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length % 8L == 0L);
                long[] bits = new long[(int)length >> 3];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = data.readLong();
                }
                instance = new FixedBitSet(bits, this.maxDoc);
                this.docsWithFieldInstances.put(fieldNumber, instance);
            }
        }
        return instance;
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue((SortedSetDocValues)this.getSortedSet(field), (int)this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue((SortedNumericDocValues)this.getSortedNumeric(field), (int)this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue((SortedDocValues)this.getSorted(field), (int)this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field.number);
                return this.getMissingBits(field.number, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne = this.numerics.get(field.number);
                return this.getMissingBits(field.number, ne.missingOffset, ne.missingBytes);
            }
        }
        throw new AssertionError();
    }

    public void close() throws IOException {
        this.data.close();
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class SortedNumericEntry {
        NumericEntry docToAddress;
        NumericEntry values;

        SortedNumericEntry() {
        }
    }

    static class SortedSetEntry {
        NumericEntry docToOrdAddress;
        NumericEntry ords;
        BinaryEntry values;

        SortedSetEntry() {
        }
    }

    static class SortedEntry {
        NumericEntry docToOrd;
        BinaryEntry values;

        SortedEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        int count;
        int numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        int count;
        long missingOffset;
        long missingBytes;
        byte byteWidth;
        int packedIntsVersion;

        NumericEntry() {
        }
    }

    static class SortedSetRawValues {
        NumericDocValues docToOrdAddress;
        NumericDocValues ords;

        SortedSetRawValues() {
        }
    }

    static class SortedNumericRawValues {
        NumericDocValues docToAddress;
        NumericDocValues values;

        SortedNumericRawValues() {
        }
    }

    static class SortedRawValues {
        NumericDocValues docToOrd;

        SortedRawValues() {
        }
    }

    static class BinaryRawValues {
        byte[] bytes;
        int[] address;

        BinaryRawValues() {
        }
    }
}

