/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class SimpleTextTermVectorsWriter
extends TermVectorsWriter {
    static final BytesRef END = new BytesRef((CharSequence)"END");
    static final BytesRef DOC = new BytesRef((CharSequence)"doc ");
    static final BytesRef NUMFIELDS = new BytesRef((CharSequence)"  numfields ");
    static final BytesRef FIELD = new BytesRef((CharSequence)"  field ");
    static final BytesRef FIELDNAME = new BytesRef((CharSequence)"    name ");
    static final BytesRef FIELDPOSITIONS = new BytesRef((CharSequence)"    positions ");
    static final BytesRef FIELDOFFSETS = new BytesRef((CharSequence)"    offsets   ");
    static final BytesRef FIELDPAYLOADS = new BytesRef((CharSequence)"    payloads  ");
    static final BytesRef FIELDTERMCOUNT = new BytesRef((CharSequence)"    numterms ");
    static final BytesRef TERMTEXT = new BytesRef((CharSequence)"    term ");
    static final BytesRef TERMFREQ = new BytesRef((CharSequence)"      freq ");
    static final BytesRef POSITION = new BytesRef((CharSequence)"      position ");
    static final BytesRef PAYLOAD = new BytesRef((CharSequence)"        payload ");
    static final BytesRef STARTOFFSET = new BytesRef((CharSequence)"        startoffset ");
    static final BytesRef ENDOFFSET = new BytesRef((CharSequence)"        endoffset ");
    static final String VECTORS_EXTENSION = "vec";
    private final Directory directory;
    private final String segment;
    private IndexOutput out;
    private int numDocsWritten = 0;
    private final BytesRef scratch = new BytesRef();
    private boolean offsets;
    private boolean positions;
    private boolean payloads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextTermVectorsWriter(Directory directory, String segment, IOContext context) throws IOException {
        this.directory = directory;
        this.segment = segment;
        boolean success = false;
        try {
            this.out = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)VECTORS_EXTENSION), context);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    public void startDocument(int numVectorFields) throws IOException {
        this.write(DOC);
        this.write(Integer.toString(this.numDocsWritten));
        this.newLine();
        this.write(NUMFIELDS);
        this.write(Integer.toString(numVectorFields));
        this.newLine();
        ++this.numDocsWritten;
    }

    public void startField(FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
        this.write(FIELD);
        this.write(Integer.toString(info.number));
        this.newLine();
        this.write(FIELDNAME);
        this.write(info.name);
        this.newLine();
        this.write(FIELDPOSITIONS);
        this.write(Boolean.toString(positions));
        this.newLine();
        this.write(FIELDOFFSETS);
        this.write(Boolean.toString(offsets));
        this.newLine();
        this.write(FIELDPAYLOADS);
        this.write(Boolean.toString(payloads));
        this.newLine();
        this.write(FIELDTERMCOUNT);
        this.write(Integer.toString(numTerms));
        this.newLine();
        this.positions = positions;
        this.offsets = offsets;
        this.payloads = payloads;
    }

    public void startTerm(BytesRef term, int freq) throws IOException {
        this.write(TERMTEXT);
        this.write(term);
        this.newLine();
        this.write(TERMFREQ);
        this.write(Integer.toString(freq));
        this.newLine();
    }

    public void addPosition(int position, int startOffset, int endOffset, BytesRef payload) throws IOException {
        assert (this.positions || this.offsets);
        if (this.positions) {
            this.write(POSITION);
            this.write(Integer.toString(position));
            this.newLine();
            if (this.payloads) {
                this.write(PAYLOAD);
                if (payload != null) {
                    assert (payload.length > 0);
                    this.write(payload);
                }
                this.newLine();
            }
        }
        if (this.offsets) {
            this.write(STARTOFFSET);
            this.write(Integer.toString(startOffset));
            this.newLine();
            this.write(ENDOFFSET);
            this.write(Integer.toString(endOffset));
            this.newLine();
        }
    }

    public void abort() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.directory, (String[])new String[]{IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)VECTORS_EXTENSION)});
    }

    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (this.numDocsWritten != numDocs) {
            throw new RuntimeException("mergeVectors produced an invalid result: mergedDocs is " + numDocs + " but vec numDocs is " + this.numDocsWritten + " file=" + this.out.toString() + "; now aborting this merge to prevent index corruption");
        }
        this.write(END);
        this.newLine();
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.out});
        }
        finally {
            this.out = null;
        }
    }

    public Comparator<BytesRef> getComparator() throws IOException {
        return BytesRef.getUTF8SortedAsUnicodeComparator();
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write((DataOutput)this.out, s, this.scratch);
    }

    private void write(BytesRef bytes) throws IOException {
        SimpleTextUtil.write((DataOutput)this.out, bytes);
    }

    private void newLine() throws IOException {
        SimpleTextUtil.writeNewline((DataOutput)this.out);
    }
}

