/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

public class FixedGapTermsIndexWriter
extends TermsIndexWriterBase {
    protected final IndexOutput out;
    static final String TERMS_INDEX_EXTENSION = "tii";
    static final String CODEC_NAME = "SIMPLE_STANDARD_TERMS_INDEX";
    static final int VERSION_START = 0;
    static final int VERSION_APPEND_ONLY = 1;
    static final int VERSION_CURRENT = 1;
    private final int termIndexInterval;
    private final List<SimpleFieldWriter> fields = new ArrayList<SimpleFieldWriter>();
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FixedGapTermsIndexWriter(SegmentWriteState state) throws IOException {
        String indexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
        this.termIndexInterval = state.termIndexInterval;
        this.out = state.directory.createOutput(indexFileName, state.context);
        boolean success = false;
        try {
            this.fieldInfos = state.fieldInfos;
            this.writeHeader(this.out);
            this.out.writeInt(this.termIndexInterval);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    private void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader((DataOutput)out, (String)CODEC_NAME, (int)1);
    }

    @Override
    public TermsIndexWriterBase.FieldWriter addField(FieldInfo field, long termsFilePointer) {
        SimpleFieldWriter writer = new SimpleFieldWriter(field, termsFilePointer);
        this.fields.add(writer);
        return writer;
    }

    protected int indexedTermPrefixLength(BytesRef priorTerm, BytesRef indexedTerm) {
        int idxTermOffset = indexedTerm.offset;
        int priorTermOffset = priorTerm.offset;
        int limit = Math.min(priorTerm.length, indexedTerm.length);
        for (int byteIdx = 0; byteIdx < limit; ++byteIdx) {
            if (priorTerm.bytes[priorTermOffset + byteIdx] == indexedTerm.bytes[idxTermOffset + byteIdx]) continue;
            return byteIdx + 1;
        }
        return Math.min(1 + priorTerm.length, indexedTerm.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    SimpleFieldWriter field;
                    int i;
                    long dirStart = this.out.getFilePointer();
                    int fieldCount = this.fields.size();
                    int nonNullFieldCount = 0;
                    for (i = 0; i < fieldCount; ++i) {
                        field = this.fields.get(i);
                        if (field.numIndexTerms <= 0) continue;
                        ++nonNullFieldCount;
                    }
                    this.out.writeVInt(nonNullFieldCount);
                    for (i = 0; i < fieldCount; ++i) {
                        field = this.fields.get(i);
                        if (field.numIndexTerms <= 0) continue;
                        this.out.writeVInt(field.fieldInfo.number);
                        this.out.writeVInt(field.numIndexTerms);
                        this.out.writeVLong(field.termsStart);
                        this.out.writeVLong(field.indexStart);
                        this.out.writeVLong(field.packedIndexStart);
                        this.out.writeVLong(field.packedOffsetsStart);
                    }
                    this.writeTrailer(dirStart);
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.out});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.out});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
        }
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    private class SimpleFieldWriter
    extends TermsIndexWriterBase.FieldWriter {
        final FieldInfo fieldInfo;
        int numIndexTerms;
        final long indexStart;
        final long termsStart;
        long packedIndexStart;
        long packedOffsetsStart;
        private long numTerms;
        private short[] termLengths;
        private int[] termsPointerDeltas;
        private long lastTermsPointer;
        private long totTermLength;
        private final BytesRef lastTerm = new BytesRef();

        SimpleFieldWriter(FieldInfo fieldInfo, long termsFilePointer) {
            this.fieldInfo = fieldInfo;
            this.indexStart = FixedGapTermsIndexWriter.this.out.getFilePointer();
            this.termsStart = this.lastTermsPointer = termsFilePointer;
            this.termLengths = new short[0];
            this.termsPointerDeltas = new int[0];
        }

        @Override
        public boolean checkIndexTerm(BytesRef text, TermStats stats) throws IOException {
            if (0L == this.numTerms++ % (long)FixedGapTermsIndexWriter.this.termIndexInterval) {
                return true;
            }
            if (0L == this.numTerms % (long)FixedGapTermsIndexWriter.this.termIndexInterval) {
                this.lastTerm.copyBytes(text);
            }
            return false;
        }

        @Override
        public void add(BytesRef text, TermStats stats, long termsFilePointer) throws IOException {
            int indexedTermLength = FixedGapTermsIndexWriter.this.indexedTermPrefixLength(this.lastTerm, text);
            FixedGapTermsIndexWriter.this.out.writeBytes(text.bytes, text.offset, indexedTermLength);
            if (this.termLengths.length == this.numIndexTerms) {
                this.termLengths = ArrayUtil.grow((short[])this.termLengths);
            }
            if (this.termsPointerDeltas.length == this.numIndexTerms) {
                this.termsPointerDeltas = ArrayUtil.grow((int[])this.termsPointerDeltas);
            }
            this.termsPointerDeltas[this.numIndexTerms] = (int)(termsFilePointer - this.lastTermsPointer);
            this.lastTermsPointer = termsFilePointer;
            assert (indexedTermLength <= Short.MAX_VALUE);
            this.termLengths[this.numIndexTerms] = (short)indexedTermLength;
            this.totTermLength += (long)indexedTermLength;
            this.lastTerm.copyBytes(text);
            ++this.numIndexTerms;
        }

        @Override
        public void finish(long termsFilePointer) throws IOException {
            int i;
            this.packedIndexStart = FixedGapTermsIndexWriter.this.out.getFilePointer();
            PackedInts.Writer w = PackedInts.getWriter((DataOutput)FixedGapTermsIndexWriter.this.out, (int)this.numIndexTerms, (int)PackedInts.bitsRequired((long)termsFilePointer), (float)0.2f);
            long upto = 0L;
            for (i = 0; i < this.numIndexTerms; ++i) {
                w.add(upto += (long)this.termsPointerDeltas[i]);
            }
            w.finish();
            this.packedOffsetsStart = FixedGapTermsIndexWriter.this.out.getFilePointer();
            w = PackedInts.getWriter((DataOutput)FixedGapTermsIndexWriter.this.out, (int)(1 + this.numIndexTerms), (int)PackedInts.bitsRequired((long)this.totTermLength), (float)0.2f);
            upto = 0L;
            for (i = 0; i < this.numIndexTerms; ++i) {
                w.add(upto);
                upto += (long)this.termLengths[i];
            }
            w.add(upto);
            w.finish();
            this.termLengths = null;
            this.termsPointerDeltas = null;
        }
    }
}

