/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class FSTOrdTermsReader
extends FieldsProducer {
    static final int INTERVAL = 8;
    final TreeMap<String, TermsReader> fields;
    final PostingsReaderBase postingsReader;
    int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTOrdTermsReader(SegmentReadState state, PostingsReaderBase postingsReader) throws IOException {
        block9: {
            IndexInput blockIn;
            ChecksumIndexInput indexIn;
            block8: {
                this.fields = new TreeMap();
                String termsIndexFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tix");
                String termsBlockFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"tbk");
                this.postingsReader = postingsReader;
                indexIn = null;
                blockIn = null;
                boolean success = false;
                try {
                    indexIn = state.directory.openChecksumInput(termsIndexFileName, state.context);
                    blockIn = state.directory.openInput(termsBlockFileName, state.context);
                    this.version = this.readHeader((IndexInput)indexIn);
                    this.readHeader(blockIn);
                    if (this.version >= 1) {
                        CodecUtil.checksumEntireFile((IndexInput)blockIn);
                    }
                    this.postingsReader.init(blockIn);
                    this.seekDir(blockIn);
                    FieldInfos fieldInfos = state.fieldInfos;
                    int numFields = blockIn.readVInt();
                    for (int i = 0; i < numFields; ++i) {
                        FieldInfo fieldInfo = fieldInfos.fieldInfo(blockIn.readVInt());
                        boolean hasFreq = fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY;
                        long numTerms = blockIn.readVLong();
                        long sumTotalTermFreq = hasFreq ? blockIn.readVLong() : -1L;
                        long sumDocFreq = blockIn.readVLong();
                        int docCount = blockIn.readVInt();
                        int longsSize = blockIn.readVInt();
                        FST index = new FST((DataInput)indexIn, (Outputs)PositiveIntOutputs.getSingleton());
                        TermsReader current = new TermsReader(fieldInfo, blockIn, numTerms, sumTotalTermFreq, sumDocFreq, docCount, longsSize, (FST<Long>)index);
                        TermsReader previous = this.fields.put(fieldInfo.name, current);
                        this.checkFieldSummary(state.segmentInfo, (IndexInput)indexIn, blockIn, current, previous);
                    }
                    if (this.version >= 1) {
                        CodecUtil.checkFooter((ChecksumIndexInput)indexIn);
                    } else {
                        CodecUtil.checkEOF((IndexInput)indexIn);
                    }
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{indexIn, blockIn});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexIn, blockIn});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{indexIn, blockIn});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexIn, blockIn});
        }
    }

    private int readHeader(IndexInput in) throws IOException {
        return CodecUtil.checkHeader((DataInput)in, (String)"FST_ORD_TERMS_DICT", (int)0, (int)1);
    }

    private void seekDir(IndexInput in) throws IOException {
        if (this.version >= 1) {
            in.seek(in.length() - (long)CodecUtil.footerLength() - 8L);
        } else {
            in.seek(in.length() - 8L);
        }
        in.seek(in.readLong());
    }

    private void checkFieldSummary(SegmentInfo info, IndexInput indexIn, IndexInput blockIn, TermsReader field, TermsReader previous) throws IOException {
        if (field.docCount < 0 || field.docCount > info.getDocCount()) {
            throw new CorruptIndexException("invalid docCount: " + field.docCount + " maxDoc: " + info.getDocCount() + " (resource=" + indexIn + ", " + blockIn + ")");
        }
        if (field.sumDocFreq < (long)field.docCount) {
            throw new CorruptIndexException("invalid sumDocFreq: " + field.sumDocFreq + " docCount: " + field.docCount + " (resource=" + indexIn + ", " + blockIn + ")");
        }
        if (field.sumTotalTermFreq != -1L && field.sumTotalTermFreq < field.sumDocFreq) {
            throw new CorruptIndexException("invalid sumTotalTermFreq: " + field.sumTotalTermFreq + " sumDocFreq: " + field.sumDocFreq + " (resource=" + indexIn + ", " + blockIn + ")");
        }
        if (previous != null) {
            throw new CorruptIndexException("duplicate fields: " + field.fieldInfo.name + " (resource=" + indexIn + ", " + blockIn + ")");
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    public int size() {
        return this.fields.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.postingsReader});
        }
        finally {
            this.fields.clear();
        }
    }

    static <T> void walk(FST<T> fst) throws IOException {
        ArrayList<FST.Arc> queue = new ArrayList<FST.Arc>();
        BitSet seen = new BitSet();
        FST.BytesReader reader = fst.getBytesReader();
        FST.Arc startArc = fst.getFirstArc(new FST.Arc());
        queue.add(startArc);
        block0: while (!queue.isEmpty()) {
            FST.Arc arc = (FST.Arc)queue.remove(0);
            long node = arc.target;
            if (!FST.targetHasArcs((FST.Arc)arc) || seen.get((int)node)) continue;
            seen.set((int)node);
            fst.readFirstRealTargetArc(node, arc, reader);
            while (true) {
                queue.add(new FST.Arc().copyFrom(arc));
                if (arc.isLast()) continue block0;
                fst.readNextRealArc(arc, reader);
            }
        }
    }

    public long ramBytesUsed() {
        long ramBytesUsed = this.postingsReader.ramBytesUsed();
        for (TermsReader r : this.fields.values()) {
            if (r.index == null) continue;
            ramBytesUsed += r.index.ramBytesUsed();
            ramBytesUsed += RamUsageEstimator.sizeOf((byte[])r.metaBytesBlock);
            ramBytesUsed += RamUsageEstimator.sizeOf((byte[])r.metaLongsBlock);
            ramBytesUsed += RamUsageEstimator.sizeOf((long[])r.skipInfo);
            ramBytesUsed += RamUsageEstimator.sizeOf((byte[])r.statsBlock);
        }
        return ramBytesUsed;
    }

    public void checkIntegrity() throws IOException {
        this.postingsReader.checkIntegrity();
    }

    final class TermsReader
    extends Terms {
        final FieldInfo fieldInfo;
        final long numTerms;
        final long sumTotalTermFreq;
        final long sumDocFreq;
        final int docCount;
        final int longsSize;
        final FST<Long> index;
        final int numSkipInfo;
        final long[] skipInfo;
        final byte[] statsBlock;
        final byte[] metaLongsBlock;
        final byte[] metaBytesBlock;

        TermsReader(FieldInfo fieldInfo, IndexInput blockIn, long numTerms, long sumTotalTermFreq, long sumDocFreq, int docCount, int longsSize, FST<Long> index) throws IOException {
            this.fieldInfo = fieldInfo;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.longsSize = longsSize;
            this.index = index;
            assert ((numTerms & 0xFFFFFFFF00000000L) == 0L);
            int numBlocks = (int)(numTerms + 8L - 1L) / 8;
            this.numSkipInfo = longsSize + 3;
            this.skipInfo = new long[numBlocks * this.numSkipInfo];
            this.statsBlock = new byte[(int)blockIn.readVLong()];
            this.metaLongsBlock = new byte[(int)blockIn.readVLong()];
            this.metaBytesBlock = new byte[(int)blockIn.readVLong()];
            int last = 0;
            int next = 0;
            for (int i = 1; i < numBlocks; ++i) {
                next = this.numSkipInfo * i;
                for (int j = 0; j < this.numSkipInfo; ++j) {
                    this.skipInfo[next + j] = this.skipInfo[last + j] + blockIn.readVLong();
                }
                last = next;
            }
            blockIn.readBytes(this.statsBlock, 0, this.statsBlock.length);
            blockIn.readBytes(this.metaLongsBlock, 0, this.metaLongsBlock.length);
            blockIn.readBytes(this.metaBytesBlock, 0, this.metaBytesBlock.length);
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public boolean hasFreqs() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.fieldInfo.hasPayloads();
        }

        public long size() {
            return this.numTerms;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public int getDocCount() throws IOException {
            return this.docCount;
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new SegmentTermsEnum();
        }

        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new IntersectTermsEnum(compiled, startTerm);
        }

        private final class IntersectTermsEnum
        extends BaseTermsEnum {
            BytesRefBuilder term;
            boolean decoded;
            boolean pending;
            Frame[] stack;
            int level;
            final FST<Long> fst;
            final FST.BytesReader fstReader;
            final Outputs<Long> fstOutputs;
            final ByteRunAutomaton fsa;

            IntersectTermsEnum(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                this.fst = TermsReader.this.index;
                this.fstReader = this.fst.getBytesReader();
                this.fstOutputs = TermsReader.this.index.outputs;
                this.fsa = compiled.runAutomaton;
                this.level = -1;
                this.stack = new Frame[16];
                for (int i = 0; i < this.stack.length; ++i) {
                    this.stack[i] = new Frame();
                }
                Frame frame = this.loadVirtualFrame(this.newFrame());
                ++this.level;
                frame = this.loadFirstFrame(this.newFrame());
                this.pushFrame(frame);
                this.decoded = false;
                this.pending = false;
                if (startTerm == null) {
                    this.pending = this.isAccept(this.topFrame());
                } else {
                    this.doSeekCeil(startTerm);
                    this.pending = (this.term == null || !startTerm.equals((Object)this.term.get())) && this.isValid(this.topFrame()) && this.isAccept(this.topFrame());
                }
            }

            public BytesRef term() throws IOException {
                return this.term == null ? null : this.term.get();
            }

            @Override
            void decodeMetaData() throws IOException {
                if (!this.decoded) {
                    super.decodeMetaData();
                    this.decoded = true;
                }
            }

            @Override
            void decodeStats() throws IOException {
                FST.Arc<Long> arc = this.topFrame().arc;
                assert (arc.nextFinalOutput == this.fstOutputs.getNoOutput());
                this.ord = (Long)arc.output;
                super.decodeStats();
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
                throw new UnsupportedOperationException();
            }

            public BytesRef next() throws IOException {
                if (this.pending) {
                    this.pending = false;
                    this.decodeStats();
                    return this.term();
                }
                this.decoded = false;
                block0: while (this.level > 0) {
                    Frame frame = this.newFrame();
                    if (this.loadExpandFrame(this.topFrame(), frame) != null) {
                        this.pushFrame(frame);
                        if (!this.isAccept(frame)) continue;
                        break;
                    }
                    frame = this.popFrame();
                    while (this.level > 0) {
                        if (this.loadNextFrame(this.topFrame(), frame) != null) {
                            this.pushFrame(frame);
                            if (!this.isAccept(frame)) continue block0;
                            break block0;
                        }
                        frame = this.popFrame();
                    }
                    return null;
                }
                this.decodeStats();
                return this.term();
            }

            BytesRef doSeekCeil(BytesRef target) throws IOException {
                int upto;
                Frame frame = null;
                int limit = target.length;
                for (upto = 0; upto < limit; ++upto) {
                    frame = this.newFrame();
                    int label = target.bytes[upto] & 0xFF;
                    frame = this.loadCeilFrame(label, this.topFrame(), frame);
                    if (frame == null || frame.arc.label != label) break;
                    assert (this.isValid(frame));
                    this.pushFrame(frame);
                }
                if (upto == limit) {
                    return this.term();
                }
                if (frame != null) {
                    this.pushFrame(frame);
                    return this.isAccept(frame) ? this.term() : this.next();
                }
                while (this.level > 0) {
                    frame = this.popFrame();
                    while (this.level > 0 && !this.canRewind(frame)) {
                        frame = this.popFrame();
                    }
                    if (this.loadNextFrame(this.topFrame(), frame) == null) continue;
                    this.pushFrame(frame);
                    return this.isAccept(frame) ? this.term() : this.next();
                }
                return null;
            }

            Frame loadVirtualFrame(Frame frame) throws IOException {
                frame.arc.output = this.fstOutputs.getNoOutput();
                frame.arc.nextFinalOutput = this.fstOutputs.getNoOutput();
                frame.state = -1;
                return frame;
            }

            Frame loadFirstFrame(Frame frame) throws IOException {
                frame.arc = this.fst.getFirstArc(frame.arc);
                frame.state = this.fsa.getInitialState();
                return frame;
            }

            Frame loadExpandFrame(Frame top, Frame frame) throws IOException {
                if (!this.canGrow(top)) {
                    return null;
                }
                frame.arc = this.fst.readFirstRealTargetArc(top.arc.target, frame.arc, this.fstReader);
                frame.state = this.fsa.step(top.state, frame.arc.label);
                if (frame.state == -1) {
                    return this.loadNextFrame(top, frame);
                }
                return frame;
            }

            Frame loadNextFrame(Frame top, Frame frame) throws IOException {
                if (!this.canRewind(frame)) {
                    return null;
                }
                while (!frame.arc.isLast()) {
                    frame.arc = this.fst.readNextRealArc(frame.arc, this.fstReader);
                    frame.state = this.fsa.step(top.state, frame.arc.label);
                    if (frame.state == -1) continue;
                }
                if (frame.state == -1) {
                    return null;
                }
                return frame;
            }

            Frame loadCeilFrame(int label, Frame top, Frame frame) throws IOException {
                FST.Arc arc = frame.arc;
                if ((arc = Util.readCeilArc((int)label, this.fst, top.arc, arc, (FST.BytesReader)this.fstReader)) == null) {
                    return null;
                }
                frame.state = this.fsa.step(top.state, arc.label);
                if (frame.state == -1) {
                    return this.loadNextFrame(top, frame);
                }
                return frame;
            }

            boolean isAccept(Frame frame) {
                return this.fsa.isAccept(frame.state) && frame.arc.isFinal();
            }

            boolean isValid(Frame frame) {
                return frame.state != -1;
            }

            boolean canGrow(Frame frame) {
                return frame.state != -1 && FST.targetHasArcs(frame.arc);
            }

            boolean canRewind(Frame frame) {
                return !frame.arc.isLast();
            }

            void pushFrame(Frame frame) {
                FST.Arc<Long> arc = frame.arc;
                arc.output = this.fstOutputs.add(this.topFrame().arc.output, arc.output);
                this.term = this.grow(arc.label);
                ++this.level;
                assert (frame == this.stack[this.level]);
            }

            Frame popFrame() {
                this.term = this.shrink();
                return this.stack[this.level--];
            }

            Frame newFrame() {
                if (this.level + 1 == this.stack.length) {
                    Frame[] temp = new Frame[ArrayUtil.oversize((int)(this.level + 2), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(this.stack, 0, temp, 0, this.stack.length);
                    for (int i = this.stack.length; i < temp.length; ++i) {
                        temp[i] = new Frame();
                    }
                    this.stack = temp;
                }
                return this.stack[this.level + 1];
            }

            Frame topFrame() {
                return this.stack[this.level];
            }

            BytesRefBuilder grow(int label) {
                if (this.term == null) {
                    this.term = new BytesRefBuilder();
                } else {
                    this.term.append((byte)label);
                }
                return this.term;
            }

            BytesRefBuilder shrink() {
                if (this.term.length() == 0) {
                    this.term = null;
                } else {
                    this.term.setLength(this.term.length() - 1);
                }
                return this.term;
            }

            private final class Frame {
                FST.Arc<Long> arc = new FST.Arc();
                int state = -1;

                Frame() {
                }

                public String toString() {
                    return "arc=" + this.arc + " state=" + this.state;
                }
            }
        }

        private final class SegmentTermsEnum
        extends BaseTermsEnum {
            final BytesRefFSTEnum<Long> fstEnum;
            BytesRef term;
            boolean decoded;
            boolean seekPending;

            SegmentTermsEnum() throws IOException {
                this.fstEnum = new BytesRefFSTEnum(TermsReader.this.index);
                this.decoded = false;
                this.seekPending = false;
            }

            public BytesRef term() throws IOException {
                return this.term;
            }

            @Override
            void decodeMetaData() throws IOException {
                if (!this.decoded && !this.seekPending) {
                    super.decodeMetaData();
                    this.decoded = true;
                }
            }

            void updateEnum(BytesRefFSTEnum.InputOutput<Long> pair) throws IOException {
                if (pair == null) {
                    this.term = null;
                } else {
                    this.term = pair.input;
                    this.ord = (Long)pair.output;
                    this.decodeStats();
                }
                this.decoded = false;
                this.seekPending = false;
            }

            public BytesRef next() throws IOException {
                if (this.seekPending) {
                    this.seekPending = false;
                    TermsEnum.SeekStatus status = this.seekCeil(this.term);
                    assert (status == TermsEnum.SeekStatus.FOUND);
                }
                this.updateEnum((BytesRefFSTEnum.InputOutput<Long>)this.fstEnum.next());
                return this.term;
            }

            public boolean seekExact(BytesRef target) throws IOException {
                this.updateEnum((BytesRefFSTEnum.InputOutput<Long>)this.fstEnum.seekExact(target));
                return this.term != null;
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
                this.updateEnum((BytesRefFSTEnum.InputOutput<Long>)this.fstEnum.seekCeil(target));
                if (this.term == null) {
                    return TermsEnum.SeekStatus.END;
                }
                return this.term.equals((Object)target) ? TermsEnum.SeekStatus.FOUND : TermsEnum.SeekStatus.NOT_FOUND;
            }

            public void seekExact(BytesRef target, TermState otherState) {
                if (!target.equals((Object)this.term)) {
                    this.state.copyFrom(otherState);
                    this.term = BytesRef.deepCopyOf((BytesRef)target);
                    this.seekPending = true;
                }
            }
        }

        abstract class BaseTermsEnum
        extends TermsEnum {
            long ord;
            final BlockTermState state;
            final ByteArrayDataInput statsReader = new ByteArrayDataInput();
            final ByteArrayDataInput metaLongsReader = new ByteArrayDataInput();
            final ByteArrayDataInput metaBytesReader = new ByteArrayDataInput();
            int statsBlockOrd;
            int metaBlockOrd;
            long[][] longs;
            int[] bytesStart;
            int[] bytesLength;
            int[] docFreq;
            long[] totalTermFreq;

            BaseTermsEnum() throws IOException {
                this.state = FSTOrdTermsReader.this.postingsReader.newTermState();
                this.statsReader.reset(TermsReader.this.statsBlock);
                this.metaLongsReader.reset(TermsReader.this.metaLongsBlock);
                this.metaBytesReader.reset(TermsReader.this.metaBytesBlock);
                this.longs = new long[8][TermsReader.this.longsSize];
                this.bytesStart = new int[8];
                this.bytesLength = new int[8];
                this.docFreq = new int[8];
                this.totalTermFreq = new long[8];
                this.statsBlockOrd = -1;
                this.metaBlockOrd = -1;
                if (!TermsReader.this.hasFreqs()) {
                    Arrays.fill(this.totalTermFreq, -1L);
                }
            }

            public Comparator<BytesRef> getComparator() {
                return BytesRef.getUTF8SortedAsUnicodeComparator();
            }

            void decodeStats() throws IOException {
                int upto = (int)this.ord % 8;
                int oldBlockOrd = this.statsBlockOrd;
                this.statsBlockOrd = (int)this.ord / 8;
                if (oldBlockOrd != this.statsBlockOrd) {
                    this.refillStats();
                }
                this.state.docFreq = this.docFreq[upto];
                this.state.totalTermFreq = this.totalTermFreq[upto];
            }

            void decodeMetaData() throws IOException {
                int upto = (int)this.ord % 8;
                int oldBlockOrd = this.metaBlockOrd;
                this.metaBlockOrd = (int)this.ord / 8;
                if (this.metaBlockOrd != oldBlockOrd) {
                    this.refillMetadata();
                }
                this.metaBytesReader.setPosition(this.bytesStart[upto]);
                FSTOrdTermsReader.this.postingsReader.decodeTerm(this.longs[upto], (DataInput)this.metaBytesReader, TermsReader.this.fieldInfo, this.state, true);
            }

            final void refillStats() throws IOException {
                int offset = this.statsBlockOrd * TermsReader.this.numSkipInfo;
                int statsFP = (int)TermsReader.this.skipInfo[offset];
                this.statsReader.setPosition(statsFP);
                for (int i = 0; i < 8 && !this.statsReader.eof(); ++i) {
                    int code = this.statsReader.readVInt();
                    if (TermsReader.this.hasFreqs()) {
                        this.docFreq[i] = code >>> 1;
                        if ((code & 1) == 1) {
                            this.totalTermFreq[i] = this.docFreq[i];
                            continue;
                        }
                        this.totalTermFreq[i] = (long)this.docFreq[i] + this.statsReader.readVLong();
                        continue;
                    }
                    this.docFreq[i] = code;
                }
            }

            final void refillMetadata() throws IOException {
                int offset = this.metaBlockOrd * TermsReader.this.numSkipInfo;
                int metaLongsFP = (int)TermsReader.this.skipInfo[offset + 1];
                int metaBytesFP = (int)TermsReader.this.skipInfo[offset + 2];
                this.metaLongsReader.setPosition(metaLongsFP);
                for (int j = 0; j < TermsReader.this.longsSize; ++j) {
                    this.longs[0][j] = TermsReader.this.skipInfo[offset + 3 + j] + this.metaLongsReader.readVLong();
                }
                this.bytesStart[0] = metaBytesFP;
                this.bytesLength[0] = (int)this.metaLongsReader.readVLong();
                for (int i = 1; i < 8 && !this.metaLongsReader.eof(); ++i) {
                    for (int j = 0; j < TermsReader.this.longsSize; ++j) {
                        this.longs[i][j] = this.longs[i - 1][j] + this.metaLongsReader.readVLong();
                    }
                    this.bytesStart[i] = this.bytesStart[i - 1] + this.bytesLength[i - 1];
                    this.bytesLength[i] = (int)this.metaLongsReader.readVLong();
                }
            }

            public TermState termState() throws IOException {
                this.decodeMetaData();
                return this.state.clone();
            }

            public int docFreq() throws IOException {
                return this.state.docFreq;
            }

            public long totalTermFreq() throws IOException {
                return this.state.totalTermFreq;
            }

            public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                this.decodeMetaData();
                return FSTOrdTermsReader.this.postingsReader.docs(TermsReader.this.fieldInfo, this.state, liveDocs, reuse, flags);
            }

            public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                if (!TermsReader.this.hasPositions()) {
                    return null;
                }
                this.decodeMetaData();
                return FSTOrdTermsReader.this.postingsReader.docsAndPositions(TermsReader.this.fieldInfo, this.state, liveDocs, reuse, flags);
            }

            public void seekExact(long ord) throws IOException {
                throw new UnsupportedOperationException();
            }

            public long ord() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

