/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.tasks.ResetInputsTask;
import org.apache.lucene.util.ArrayUtil;

public class TaskSequence
extends PerfTask {
    public static int REPEAT_EXHAUST = -2;
    private ArrayList<PerfTask> tasks;
    private int repetitions = 1;
    private boolean parallel;
    private TaskSequence parent;
    private boolean letChildReport = true;
    private int rate = 0;
    private boolean perMin = false;
    private String seqName;
    private boolean exhausted = false;
    private boolean resetExhausted = false;
    private PerfTask[] tasksArray;
    private boolean anyExhaustibleTasks;
    private boolean collapsable = false;
    private boolean fixedTime;
    private double runTimeSec;
    private final long logByTimeMsec;
    private int[] countsByTime;
    ParallelTask[] runningParallelTasks;

    public TaskSequence(PerfRunData runData, String name, TaskSequence parent, boolean parallel) {
        super(runData);
        boolean bl = this.collapsable = name == null;
        name = name != null ? name : (parallel ? "Par" : "Seq");
        this.setName(name);
        this.setSequenceName();
        this.parent = parent;
        this.parallel = parallel;
        this.tasks = new ArrayList();
        this.logByTimeMsec = runData.getConfig().get("report.time.step.msec", 0);
    }

    @Override
    public void close() throws Exception {
        this.initTasksArray();
        for (int i = 0; i < this.tasksArray.length; ++i) {
            this.tasksArray[i].close();
        }
        this.getRunData().getDocMaker().close();
    }

    private void initTasksArray() {
        if (this.tasksArray == null) {
            int numTasks = this.tasks.size();
            this.tasksArray = new PerfTask[numTasks];
            for (int k = 0; k < numTasks; ++k) {
                this.tasksArray[k] = this.tasks.get(k);
                this.anyExhaustibleTasks |= this.tasksArray[k] instanceof ResetInputsTask;
                this.anyExhaustibleTasks |= this.tasksArray[k] instanceof TaskSequence;
            }
        }
        if (!this.parallel && this.logByTimeMsec != 0L && !this.letChildReport) {
            this.countsByTime = new int[1];
        }
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRunTime(double sec) throws Exception {
        this.runTimeSec = sec;
        this.fixedTime = true;
    }

    public void setRepetitions(int repetitions) throws Exception {
        this.fixedTime = false;
        this.repetitions = repetitions;
        if (repetitions == REPEAT_EXHAUST && this.isParallel()) {
            throw new Exception("REPEAT_EXHAUST is not allowed for parallel tasks");
        }
        this.setSequenceName();
    }

    public TaskSequence getParent() {
        return this.parent;
    }

    @Override
    public int doLogic() throws Exception {
        this.resetExhausted = false;
        this.exhausted = false;
        return this.parallel ? this.doParallelTasks() : this.doSerialTasks();
    }

    private int doSerialTasks() throws Exception {
        if (this.rate > 0) {
            return this.doSerialTasksWithRate();
        }
        this.initTasksArray();
        int count = 0;
        long runTime = (long)(this.runTimeSec * 1000.0);
        ArrayList<RunBackgroundTask> bgTasks = null;
        long t0 = System.currentTimeMillis();
        for (int k = 0; (this.fixedTime || this.repetitions == REPEAT_EXHAUST && !this.exhausted || k < this.repetitions) && !this.stopNow; ++k) {
            for (int l = 0; l < this.tasksArray.length; ++l) {
                PerfTask task = this.tasksArray[l];
                if (task.getRunInBackground()) {
                    if (bgTasks == null) {
                        bgTasks = new ArrayList<RunBackgroundTask>();
                    }
                    RunBackgroundTask bgTask = new RunBackgroundTask(task, this.letChildReport);
                    bgTask.setPriority(task.getBackgroundDeltaPriority() + Thread.currentThread().getPriority());
                    bgTask.start();
                    bgTasks.add(bgTask);
                    continue;
                }
                try {
                    int inc = task.runAndMaybeStats(this.letChildReport);
                    count += inc;
                    if (this.countsByTime != null) {
                        int slot = (int)((System.currentTimeMillis() - t0) / this.logByTimeMsec);
                        if (slot >= this.countsByTime.length) {
                            this.countsByTime = ArrayUtil.grow((int[])this.countsByTime, (int)(1 + slot));
                        }
                        int n = slot;
                        this.countsByTime[n] = this.countsByTime[n] + inc;
                    }
                    if (!this.anyExhaustibleTasks) continue;
                    this.updateExhausted(task);
                    continue;
                }
                catch (NoMoreDataException e) {
                    this.exhausted = true;
                }
            }
            if (!this.fixedTime || System.currentTimeMillis() - t0 <= runTime) continue;
            this.repetitions = k + 1;
            break;
        }
        if (bgTasks != null) {
            for (RunBackgroundTask bgTask : bgTasks) {
                bgTask.stopNow();
            }
            for (RunBackgroundTask bgTask : bgTasks) {
                bgTask.join();
                count += bgTask.getCount();
            }
        }
        if (this.countsByTime != null) {
            this.getRunData().getPoints().getCurrentStats().setCountsByTime(this.countsByTime, this.logByTimeMsec);
        }
        this.stopNow = false;
        return count;
    }

    private int doSerialTasksWithRate() throws Exception {
        this.initTasksArray();
        long delayStep = (this.perMin ? 60000 : 1000) / this.rate;
        long nextStartTime = System.currentTimeMillis();
        int count = 0;
        long t0 = System.currentTimeMillis();
        block2: for (int k = 0; (this.repetitions == REPEAT_EXHAUST && !this.exhausted || k < this.repetitions) && !this.stopNow; ++k) {
            for (int l = 0; l < this.tasksArray.length; ++l) {
                long waitMore;
                PerfTask task = this.tasksArray[l];
                while (!this.stopNow && (waitMore = nextStartTime - System.currentTimeMillis()) > 0L) {
                    Thread.sleep(1L);
                }
                if (this.stopNow) continue block2;
                nextStartTime += delayStep;
                try {
                    int inc = task.runAndMaybeStats(this.letChildReport);
                    count += inc;
                    if (this.countsByTime != null) {
                        int slot = (int)((System.currentTimeMillis() - t0) / this.logByTimeMsec);
                        if (slot >= this.countsByTime.length) {
                            this.countsByTime = ArrayUtil.grow((int[])this.countsByTime, (int)(1 + slot));
                        }
                        int n = slot;
                        this.countsByTime[n] = this.countsByTime[n] + inc;
                    }
                    if (!this.anyExhaustibleTasks) continue;
                    this.updateExhausted(task);
                    continue;
                }
                catch (NoMoreDataException e) {
                    this.exhausted = true;
                }
            }
        }
        this.stopNow = false;
        return count;
    }

    private void updateExhausted(PerfTask task) {
        if (task instanceof ResetInputsTask) {
            this.exhausted = false;
            this.resetExhausted = true;
        } else if (task instanceof TaskSequence) {
            TaskSequence t = (TaskSequence)task;
            if (t.resetExhausted) {
                this.exhausted = false;
                this.resetExhausted = true;
                t.resetExhausted = false;
            } else {
                this.exhausted |= t.exhausted;
            }
        }
    }

    @Override
    public void stopNow() {
        super.stopNow();
        if (this.runningParallelTasks != null) {
            for (ParallelTask t : this.runningParallelTasks) {
                if (t == null) continue;
                t.task.stopNow();
            }
        }
    }

    private int doParallelTasks() throws Exception {
        int i;
        TaskStats stats = this.getRunData().getPoints().getCurrentStats();
        this.initTasksArray();
        this.runningParallelTasks = new ParallelTask[this.repetitions * this.tasks.size()];
        ParallelTask[] t = this.runningParallelTasks;
        this.getRunData().getConfig().setNumThreads(t.length);
        int index = 0;
        for (int k = 0; k < this.repetitions; ++k) {
            for (i = 0; i < this.tasksArray.length; ++i) {
                PerfTask task = this.tasksArray[i].clone();
                t[index] = new ParallelTask(task);
                t[index].setName("ParallelTaskThread-" + index);
                ++index;
            }
        }
        this.startThreads(t);
        if (this.stopNow) {
            ParallelTask[] k = t;
            i = k.length;
            for (int task = 0; task < i; ++task) {
                ParallelTask task2 = k[task];
                task2.task.stopNow();
            }
        }
        int count = 0;
        for (i = 0; i < t.length; ++i) {
            t[i].join();
            count += t[i].count;
            if (!(t[i].task instanceof TaskSequence)) continue;
            TaskSequence sub = (TaskSequence)t[i].task;
            if (sub.countsByTime == null) continue;
            if (this.countsByTime == null) {
                this.countsByTime = new int[sub.countsByTime.length];
            } else if (this.countsByTime.length < sub.countsByTime.length) {
                this.countsByTime = ArrayUtil.grow((int[])this.countsByTime, (int)sub.countsByTime.length);
            }
            for (int j = 0; j < sub.countsByTime.length; ++j) {
                int n = j;
                this.countsByTime[n] = this.countsByTime[n] + sub.countsByTime[j];
            }
        }
        if (this.countsByTime != null) {
            stats.setCountsByTime(this.countsByTime, this.logByTimeMsec);
        }
        return count;
    }

    private void startThreads(ParallelTask[] t) throws InterruptedException {
        if (this.rate > 0) {
            this.startlThreadsWithRate(t);
            return;
        }
        for (int i = 0; i < t.length; ++i) {
            t[i].start();
        }
    }

    private void startlThreadsWithRate(ParallelTask[] t) throws InterruptedException {
        long delayStep = (this.perMin ? 60000 : 1000) / this.rate;
        long nextStartTime = System.currentTimeMillis();
        for (int i = 0; i < t.length; ++i) {
            long waitMore = nextStartTime - System.currentTimeMillis();
            if (waitMore > 0L) {
                Thread.sleep(waitMore);
            }
            nextStartTime += delayStep;
            t[i].start();
        }
    }

    public void addTask(PerfTask task) {
        this.tasks.add(task);
        task.setDepth(this.getDepth() + 1);
    }

    @Override
    public String toString() {
        String padd = this.getPadding();
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(this.parallel ? " [" : " {");
        sb.append(NEW_LINE);
        for (PerfTask task : this.tasks) {
            sb.append(task.toString());
            sb.append(NEW_LINE);
        }
        sb.append(padd);
        sb.append(!this.letChildReport ? ">" : (this.parallel ? "]" : "}"));
        if (this.fixedTime) {
            sb.append(' ').append(NumberFormat.getNumberInstance(Locale.ROOT).format(this.runTimeSec)).append('s');
        } else if (this.repetitions > 1) {
            sb.append(" * ").append(this.repetitions);
        } else if (this.repetitions == REPEAT_EXHAUST) {
            sb.append(" * EXHAUST");
        }
        if (this.rate > 0) {
            sb.append(",  rate: ").append(this.rate).append('/').append(this.perMin ? "min" : "sec");
        }
        if (this.getRunInBackground()) {
            sb.append(" &");
            int x = this.getBackgroundDeltaPriority();
            if (x != 0) {
                sb.append(x);
            }
        }
        return sb.toString();
    }

    public void setNoChildReport() {
        this.letChildReport = false;
        for (PerfTask task : this.tasks) {
            if (!(task instanceof TaskSequence)) continue;
            ((TaskSequence)task).setNoChildReport();
        }
    }

    public int getRate() {
        return this.perMin ? this.rate : 60 * this.rate;
    }

    public void setRate(int rate, boolean perMin) {
        this.rate = rate;
        this.perMin = perMin;
        this.setSequenceName();
    }

    private void setSequenceName() {
        this.seqName = super.getName();
        if (this.repetitions == REPEAT_EXHAUST) {
            this.seqName = this.seqName + "_Exhaust";
        } else if (this.repetitions > 1) {
            this.seqName = this.seqName + "_" + this.repetitions;
        }
        if (this.rate > 0) {
            this.seqName = this.seqName + "_" + this.rate + (this.perMin ? "/min" : "/sec");
        }
        if (this.parallel && this.seqName.toLowerCase(Locale.ROOT).indexOf("par") < 0) {
            this.seqName = this.seqName + "_Par";
        }
    }

    @Override
    public String getName() {
        return this.seqName;
    }

    public ArrayList<PerfTask> getTasks() {
        return this.tasks;
    }

    @Override
    protected TaskSequence clone() throws CloneNotSupportedException {
        TaskSequence res = (TaskSequence)super.clone();
        res.tasks = new ArrayList();
        for (int i = 0; i < this.tasks.size(); ++i) {
            res.tasks.add(this.tasks.get(i).clone());
        }
        return res;
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    private static class RunBackgroundTask
    extends Thread {
        private final PerfTask task;
        private final boolean letChildReport;
        private volatile int count;

        public RunBackgroundTask(PerfTask task, boolean letChildReport) {
            this.task = task;
            this.letChildReport = letChildReport;
        }

        public void stopNow() throws InterruptedException {
            this.task.stopNow();
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void run() {
            try {
                this.count = this.task.runAndMaybeStats(this.letChildReport);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ParallelTask
    extends Thread {
        public int count;
        public final PerfTask task;

        public ParallelTask(PerfTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                int n = this.task.runAndMaybeStats(TaskSequence.this.letChildReport);
                if (TaskSequence.this.anyExhaustibleTasks) {
                    TaskSequence.this.updateExhausted(this.task);
                }
                this.count += n;
            }
            catch (NoMoreDataException e) {
                TaskSequence.this.exhausted = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

