/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.search.Query;

public abstract class AbstractQueryMaker
implements QueryMaker {
    protected int qnum = 0;
    protected Query[] queries;
    protected Config config;

    @Override
    public void resetInputs() throws Exception {
        this.qnum = 0;
        this.setConfig(this.config);
    }

    protected abstract Query[] prepareQueries() throws Exception;

    @Override
    public void setConfig(Config config) throws Exception {
        this.config = config;
        this.queries = this.prepareQueries();
    }

    @Override
    public String printQueries() {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        if (this.queries != null) {
            for (int i = 0; i < this.queries.length; ++i) {
                sb.append(i).append(". ").append(this.queries[i].getClass().getSimpleName()).append(" - ").append(this.queries[i].toString());
                sb.append(newline);
            }
        }
        return sb.toString();
    }

    @Override
    public Query makeQuery() throws Exception {
        return this.queries[this.nextQnum()];
    }

    protected synchronized int nextQnum() {
        int res = this.qnum;
        this.qnum = (this.qnum + 1) % this.queries.length;
        return res;
    }

    @Override
    public Query makeQuery(int size) throws Exception {
        throw new Exception(this + ".makeQuery(int size) is not supported!");
    }
}

