/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;

public abstract class ReadTask
extends PerfTask {
    private final QueryMaker queryMaker = this.withSearch() ? this.getQueryMaker() : null;
    static final int DEFAULT_SEARCH_NUM_HITS = 10;
    private int numHits;

    public ReadTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public int doLogic() throws Exception {
        boolean closeSearcher;
        IndexReader reader;
        int res = 0;
        IndexSearcher searcher = this.getRunData().getIndexSearcher();
        if (searcher == null) {
            Directory dir = this.getRunData().getDirectory();
            reader = DirectoryReader.open((Directory)dir);
            searcher = new IndexSearcher(reader);
            closeSearcher = true;
        } else {
            reader = searcher.getIndexReader();
            closeSearcher = false;
        }
        StoredFields storedFields = reader.storedFields();
        if (this.withWarm()) {
            Document doc = null;
            Bits liveDocs = MultiBits.getLiveDocs((IndexReader)reader);
            for (int m = 0; m < reader.maxDoc(); ++m) {
                if (null != liveDocs && !liveDocs.get(m)) continue;
                doc = storedFields.document(m);
                res += doc == null ? 0 : 1;
            }
        }
        if (this.withSearch()) {
            ++res;
            Query q = this.queryMaker.makeQuery();
            Sort sort = this.getSort();
            TopDocs hits = null;
            int numHits = this.numHits();
            if (numHits > 0) {
                Collector collector;
                if (!this.withCollector()) {
                    if (sort != null) {
                        collector = TopFieldCollector.create((Sort)sort, (int)numHits, (int)(this.withTotalHits() ? Integer.MAX_VALUE : 1));
                        searcher.search(q, collector);
                        hits = collector.topDocs();
                    } else {
                        hits = searcher.search(q, numHits);
                    }
                } else {
                    collector = this.createCollector();
                    searcher.search(q, collector);
                }
                if (hits != null) {
                    String printHitsField = this.getRunData().getConfig().get("print.hits.field", null);
                    if (printHitsField != null && printHitsField.length() > 0) {
                        System.out.println("totalHits = " + hits.totalHits);
                        System.out.println("maxDoc()  = " + reader.maxDoc());
                        System.out.println("numDocs() = " + reader.numDocs());
                        for (int i = 0; i < hits.scoreDocs.length; ++i) {
                            int docID = hits.scoreDocs[i].doc;
                            Document doc = storedFields.document(docID);
                            System.out.println("  " + i + ": doc=" + docID + " score=" + hits.scoreDocs[i].score + " " + printHitsField + " =" + doc.get(printHitsField));
                        }
                    }
                    res += this.withTopDocs(searcher, q, hits);
                }
            }
        }
        if (closeSearcher) {
            reader.close();
        } else {
            reader.decRef();
        }
        return res;
    }

    protected int withTopDocs(IndexSearcher searcher, Query q, TopDocs hits) throws Exception {
        int res = 0;
        if (this.withTraverse()) {
            ScoreDoc[] scoreDocs = hits.scoreDocs;
            int traversalSize = Math.min(scoreDocs.length, this.traversalSize());
            StoredFields storedFields = searcher.storedFields();
            if (traversalSize > 0) {
                boolean retrieve = this.withRetrieve();
                for (int m = 0; m < traversalSize; ++m) {
                    int id = scoreDocs[m].doc;
                    ++res;
                    if (!retrieve) continue;
                    Document document = this.retrieveDoc(storedFields, id);
                    res += document != null ? 1 : 0;
                }
            }
        }
        return res;
    }

    protected Collector createCollector() throws Exception {
        return TopScoreDocCollector.create((int)this.numHits(), (int)(this.withTotalHits() ? Integer.MAX_VALUE : 1));
    }

    protected Document retrieveDoc(StoredFields storedFields, int id) throws IOException {
        return storedFields.document(id);
    }

    public abstract QueryMaker getQueryMaker();

    public abstract boolean withSearch();

    public boolean withCollector() {
        return false;
    }

    public abstract boolean withWarm();

    public abstract boolean withTraverse();

    public boolean withTotalHits() {
        return false;
    }

    public int traversalSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.numHits = this.getRunData().getConfig().get("search.num.hits", 10);
    }

    public int numHits() {
        return this.numHits;
    }

    public abstract boolean withRetrieve();

    protected Sort getSort() {
        return null;
    }
}

