/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class ReutersContentSource
extends ContentSource {
    private ThreadLocal<DateFormatInfo> dateFormat = new ThreadLocal();
    private Path dataDir = null;
    private ArrayList<Path> inputFiles = new ArrayList();
    private int[] docCountArr;
    private volatile boolean docCountArrCreated;

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        Path workDir = Paths.get(config.get("work.dir", "work"), new String[0]);
        String d = config.get("docs.dir", "reuters-out");
        this.dataDir = Paths.get(d, new String[0]);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = workDir.resolve(d);
        }
        this.inputFiles.clear();
        try {
            this.collectFiles(this.dataDir, this.inputFiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.inputFiles.size() == 0) {
            throw new RuntimeException("No txt files in dataDir: " + this.dataDir.toAbsolutePath());
        }
    }

    private synchronized DateFormatInfo getDateFormatInfo() {
        DateFormatInfo dfi = this.dateFormat.get();
        if (dfi == null) {
            dfi = new DateFormatInfo();
            dfi.df = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.ENGLISH);
            dfi.df.setLenient(true);
            dfi.pos = new ParsePosition(0);
            this.dateFormat.set(dfi);
        }
        return dfi;
    }

    private Date parseDate(String dateStr) {
        DateFormatInfo dfi = this.getDateFormatInfo();
        dfi.pos.setIndex(0);
        dfi.pos.setErrorIndex(-1);
        return dfi.df.parse(dateStr.trim(), dfi.pos);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        if (!this.docCountArrCreated) {
            this.docCountArrInit();
        }
        int threadIndexSize = Thread.currentThread().getName().length();
        int parallelTaskThreadSize = "ParallelTaskThread".length();
        int threadIndex = 0;
        if (this.docCountArr.length > 1) {
            threadIndex = Integer.parseInt(Thread.currentThread().getName().substring(parallelTaskThreadSize + 1, threadIndexSize));
        }
        assert (threadIndex >= 0 && threadIndex < this.docCountArr.length) : "Please check threadIndex or docCountArr length";
        int stride = threadIndex + this.docCountArr[threadIndex] * this.docCountArr.length;
        int inFileSize = this.inputFiles.size();
        int fileIndex = stride % inFileSize;
        int iteration = stride / inFileSize;
        int n = threadIndex;
        this.docCountArr[n] = this.docCountArr[n] + 1;
        Path f = this.inputFiles.get(fileIndex);
        String name = f.toRealPath(new LinkOption[0]) + "_" + iteration;
        try (BufferedReader reader = Files.newBufferedReader(f, StandardCharsets.UTF_8);){
            String dateStr = reader.readLine();
            reader.readLine();
            String title = reader.readLine();
            reader.readLine();
            StringBuilder bodyBuf = new StringBuilder(1024);
            String line = null;
            while ((line = reader.readLine()) != null) {
                bodyBuf.append(line).append(' ');
            }
            this.addBytes(Files.size(f));
            Date date = this.parseDate(dateStr.trim());
            docData.clear();
            docData.setName(name);
            docData.setBody(bodyBuf.toString());
            docData.setTitle(title);
            docData.setDate(date);
            DocData docData2 = docData;
            return docData2;
        }
    }

    @Override
    public synchronized void resetInputs() throws IOException {
        super.resetInputs();
    }

    private synchronized void docCountArrInit() {
        if (!this.docCountArrCreated) {
            this.docCountArr = new int[this.getConfig().getNumThreads()];
            this.docCountArrCreated = true;
        }
    }

    private static final class DateFormatInfo {
        DateFormat df;
        ParsePosition pos;

        private DateFormatInfo() {
        }
    }
}

