/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Stack;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class DirContentSource
extends ContentSource {
    private ThreadLocal<DateFormatInfo> dateFormat = new ThreadLocal();
    private Path dataDir = null;
    private int iteration = 0;
    private Iterator inputFiles = null;

    private DateFormatInfo getDateFormatInfo() {
        DateFormatInfo dfi = this.dateFormat.get();
        if (dfi == null) {
            dfi = new DateFormatInfo();
            dfi.pos = new ParsePosition(0);
            dfi.df = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.ENGLISH);
            dfi.df.setLenient(true);
            this.dateFormat.set(dfi);
        }
        return dfi;
    }

    private Date parseDate(String dateStr) {
        DateFormatInfo dfi = this.getDateFormatInfo();
        dfi.pos.setIndex(0);
        dfi.pos.setErrorIndex(-1);
        return dfi.df.parse(dateStr.trim(), dfi.pos);
    }

    @Override
    public void close() throws IOException {
        this.inputFiles = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        Path f = null;
        String name = null;
        DirContentSource dirContentSource = this;
        synchronized (dirContentSource) {
            if (!this.inputFiles.hasNext()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.inputFiles = new Iterator(this.dataDir);
                ++this.iteration;
            }
            f = this.inputFiles.next();
            name = f.toRealPath(new LinkOption[0]) + "_" + this.iteration;
        }
        BufferedReader reader = Files.newBufferedReader(f, StandardCharsets.UTF_8);
        String line = null;
        String dateStr = reader.readLine();
        reader.readLine();
        String title = reader.readLine();
        reader.readLine();
        StringBuilder bodyBuf = new StringBuilder(1024);
        while ((line = reader.readLine()) != null) {
            bodyBuf.append(line).append(' ');
        }
        reader.close();
        this.addBytes(Files.size(f));
        Date date = this.parseDate(dateStr);
        docData.clear();
        docData.setName(name);
        docData.setBody(bodyBuf.toString());
        docData.setTitle(title);
        docData.setDate(date);
        return docData;
    }

    @Override
    public synchronized void resetInputs() throws IOException {
        super.resetInputs();
        this.inputFiles = new Iterator(this.dataDir);
        this.iteration = 0;
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        Path workDir = Paths.get(config.get("work.dir", "work"), new String[0]);
        String d = config.get("docs.dir", "dir-out");
        this.dataDir = Paths.get(d, new String[0]);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = workDir.resolve(d);
        }
        try {
            this.inputFiles = new Iterator(this.dataDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.inputFiles == null) {
            throw new RuntimeException("No txt files in dataDir: " + this.dataDir.toAbsolutePath());
        }
    }

    public static class Iterator
    implements java.util.Iterator<Path> {
        int count = 0;
        Stack<Path> stack = new Stack();
        Comparator c = new Comparator();

        public Iterator(Path f) throws IOException {
            this.push(f);
        }

        void find() throws IOException {
            if (this.stack.empty()) {
                return;
            }
            if (!Files.isDirectory(this.stack.peek(), new LinkOption[0])) {
                return;
            }
            Path f = this.stack.pop();
            this.push(f);
        }

        void push(Path f) throws IOException {
            ArrayList<Path> found;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(f);){
                found = new ArrayList<Path>();
                for (Path p : stream) {
                    if (!Files.isDirectory(p, new LinkOption[0])) continue;
                    found.add(p);
                }
                this.push(found.toArray(new Path[found.size()]));
            }
            stream = Files.newDirectoryStream(f, "*.txt");
            try {
                found = new ArrayList();
                for (Path p : stream) {
                    found.add(p);
                }
                this.push(found.toArray(new Path[found.size()]));
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            this.find();
        }

        void push(Path[] files) {
            Arrays.sort(files, this.c);
            for (int i = 0; i < files.length; ++i) {
                this.stack.push(files[i]);
            }
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public boolean hasNext() {
            return this.stack.size() > 0;
        }

        @Override
        public Path next() {
            assert (this.hasNext());
            ++this.count;
            Path object = this.stack.pop();
            try {
                this.find();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return object;
        }

        @Override
        public void remove() {
            throw new RuntimeException("cannot");
        }

        static class Comparator
        implements java.util.Comparator<Path> {
            Comparator() {
            }

            @Override
            public int compare(Path _a, Path _b) {
                Object b;
                Object a;
                block3: {
                    int diff;
                    block2: {
                        a = _a.toString();
                        b = _b.toString();
                        diff = ((String)a).length() - ((String)b).length();
                        if (diff <= 0) break block2;
                        while (diff-- > 0) {
                            b = "0" + (String)b;
                        }
                        break block3;
                    }
                    if (diff >= 0) break block3;
                    diff = -diff;
                    while (diff-- > 0) {
                        a = "0" + (String)a;
                    }
                }
                return ((String)b).compareTo((String)a);
            }
        }
    }

    private static final class DateFormatInfo {
        DateFormat df;
        ParsePosition pos;

        private DateFormatInfo() {
        }
    }
}

