/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.lucene.benchmark.quality.Judge;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.QualityQueryParser;
import org.apache.lucene.benchmark.quality.QualityStats;
import org.apache.lucene.benchmark.quality.utils.DocNameExtractor;
import org.apache.lucene.benchmark.quality.utils.SubmissionReport;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class QualityBenchmark {
    protected QualityQuery[] qualityQueries;
    protected QualityQueryParser qqParser;
    protected IndexSearcher searcher;
    protected String docNameField;
    private int maxQueries = Integer.MAX_VALUE;
    private int maxResults = 1000;

    public QualityBenchmark(QualityQuery[] qqs, QualityQueryParser qqParser, IndexSearcher searcher, String docNameField) {
        this.qualityQueries = qqs;
        this.qqParser = qqParser;
        this.searcher = searcher;
        this.docNameField = docNameField;
    }

    public QualityStats[] execute(Judge judge, SubmissionReport submitRep, PrintWriter qualityLog) throws Exception {
        int nQueries = Math.min(this.maxQueries, this.qualityQueries.length);
        QualityStats[] stats = new QualityStats[nQueries];
        for (int i = 0; i < nQueries; ++i) {
            QualityQuery qq = this.qualityQueries[i];
            Query q = this.qqParser.parse(qq);
            long t1 = System.currentTimeMillis();
            TopDocs td = this.searcher.search(q, this.maxResults);
            long searchTime = System.currentTimeMillis() - t1;
            if (judge != null) {
                stats[i] = this.analyzeQueryResults(qq, q, td, judge, qualityLog, searchTime);
            }
            if (submitRep == null) continue;
            submitRep.report(qq, td, this.docNameField, this.searcher);
        }
        if (submitRep != null) {
            submitRep.flush();
        }
        return stats;
    }

    private QualityStats analyzeQueryResults(QualityQuery qq, Query q, TopDocs td, Judge judge, PrintWriter logger, long searchTime) throws IOException {
        QualityStats stts = new QualityStats(judge.maxRecall(qq), searchTime);
        ScoreDoc[] sd = td.scoreDocs;
        long t1 = System.currentTimeMillis();
        DocNameExtractor xt = new DocNameExtractor(this.docNameField);
        for (int i = 0; i < sd.length; ++i) {
            String docName = xt.docName(this.searcher, sd[i].doc);
            long docNameExtractTime = System.currentTimeMillis() - t1;
            t1 = System.currentTimeMillis();
            boolean isRelevant = judge.isRelevant(docName, qq);
            stts.addResult(i + 1, isRelevant, docNameExtractTime);
        }
        if (logger != null) {
            logger.println(qq.getQueryID() + "  -  " + q);
            stts.log(qq.getQueryID() + " Stats:", 1, logger, "  ");
        }
        return stts;
    }

    public int getMaxQueries() {
        return this.maxQueries;
    }

    public void setMaxQueries(int maxQueries) {
        this.maxQueries = maxQueries;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }
}

