/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.AnalyzerFactory;
import org.apache.lucene.util.Version;

public class AnalyzerFactoryTask
extends PerfTask {
    private static final String LUCENE_ANALYSIS_PACKAGE_PREFIX = "org.apache.lucene.analysis.";
    private static final Pattern ANALYSIS_COMPONENT_SUFFIX_PATTERN = Pattern.compile("(?s:(?:(?:Token|Char)?Filter|Tokenizer)(?:Factory)?)$");
    private static final Pattern TRAILING_DOT_ZERO_PATTERN = Pattern.compile("\\.0$");
    String factoryName = null;
    Integer positionIncrementGap = null;
    Integer offsetGap = null;
    private List<CharFilterFactory> charFilterFactories = new ArrayList<CharFilterFactory>();
    private TokenizerFactory tokenizerFactory = null;
    private List<TokenFilterFactory> tokenFilterFactories = new ArrayList<TokenFilterFactory>();

    public AnalyzerFactoryTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public int doLogic() {
        return 1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setParams(String params) {
        super.setParams(params);
        expectedArgType = ArgType.ANALYZER_ARG;
        stok = new StreamTokenizer(new StringReader(params));
        stok.commentChar(35);
        stok.quoteChar(34);
        stok.quoteChar(39);
        stok.eolIsSignificant(false);
        stok.ordinaryChar(40);
        stok.ordinaryChar(41);
        stok.ordinaryChar(58);
        stok.ordinaryChar(44);
lbl12:
        // 4 sources

        try {
            block27: while (stok.nextToken() != -1) {
                switch (stok.ttype) {
                    case 44: {
                        continue block27;
                    }
                    case -3: {
                        if (!expectedArgType.equals((Object)ArgType.ANALYZER_ARG)) ** GOTO lbl53
                        argName = stok.sval;
                        if (!(argName.equalsIgnoreCase("name") || argName.equalsIgnoreCase("positionIncrementGap") || argName.equalsIgnoreCase("offsetGap"))) {
                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Missing 'name' param to AnalyzerFactory: '" + params + "'");
                        }
                        stok.nextToken();
                        if (stok.ttype != 58) {
                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Missing ':' after '" + argName + "' param to AnalyzerFactory");
                        }
                        stok.nextToken();
                        argValue = stok.sval;
                        switch (stok.ttype) {
                            case -2: {
                                argValue = Double.toString(stok.nval);
                                argValue = AnalyzerFactoryTask.TRAILING_DOT_ZERO_PATTERN.matcher(argValue).replaceFirst("");
                            }
                            case -3: 
                            case 34: 
                            case 39: {
                                if (!argName.equalsIgnoreCase("name")) ** GOTO lbl38
                                this.factoryName = argValue;
                                expectedArgType = ArgType.ANALYZER_ARG_OR_CHARFILTER_OR_TOKENIZER;
                                ** GOTO lbl12
lbl38:
                                // 1 sources

                                intArgValue = 0;
                                try {
                                    intArgValue = Integer.parseInt(argValue);
                                }
                                catch (NumberFormatException e) {
                                    throw new RuntimeException("Line #" + this.lineno(stok) + ": Exception parsing " + argName + " value '" + argValue + "'", e);
                                }
                                if (!argName.equalsIgnoreCase("positionIncrementGap")) ** GOTO lbl47
                                this.positionIncrementGap = intArgValue;
                                ** GOTO lbl12
lbl47:
                                // 1 sources

                                if (!argName.equalsIgnoreCase("offsetGap")) continue block27;
                                this.offsetGap = intArgValue;
                                ** GOTO lbl12
                            }
                            case -1: {
                                throw new RuntimeException("Unexpected EOF: " + stok.toString());
                            }
                        }
                        throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected token: " + stok.toString());
lbl53:
                        // 1 sources

                        if (expectedArgType.equals((Object)ArgType.ANALYZER_ARG_OR_CHARFILTER_OR_TOKENIZER)) {
                            argName = stok.sval;
                            if (argName.equalsIgnoreCase("positionIncrementGap") || argName.equalsIgnoreCase("offsetGap")) {
                                stok.nextToken();
                                if (stok.ttype != 58) {
                                    throw new RuntimeException("Line #" + this.lineno(stok) + ": Missing ':' after '" + argName + "' param to AnalyzerFactory");
                                }
                                stok.nextToken();
                                intArgValue = (int)stok.nval;
                                switch (stok.ttype) {
                                    case -3: 
                                    case 34: 
                                    case 39: {
                                        intArgValue = 0;
                                        try {
                                            intArgValue = Integer.parseInt(stok.sval.trim());
                                        }
                                        catch (NumberFormatException e) {
                                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Exception parsing " + argName + " value '" + stok.sval + "'", e);
                                        }
                                    }
                                    case -2: {
                                        if (argName.equalsIgnoreCase("positionIncrementGap")) {
                                            this.positionIncrementGap = intArgValue;
                                            continue block27;
                                        }
                                        if (!argName.equalsIgnoreCase("offsetGap")) continue block27;
                                        this.offsetGap = intArgValue;
                                        continue block27;
                                    }
                                    case -1: {
                                        throw new RuntimeException("Unexpected EOF: " + stok.toString());
                                    }
                                }
                                throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected token: " + stok.toString());
                            }
                            try {
                                clazz = this.lookupAnalysisClass(argName, CharFilterFactory.class);
                                this.createAnalysisPipelineComponent(stok, clazz);
                                continue block27;
                            }
                            catch (IllegalArgumentException e) {
                                try {
                                    clazz = this.lookupAnalysisClass(argName, TokenizerFactory.class);
                                    this.createAnalysisPipelineComponent(stok, clazz);
                                    expectedArgType = ArgType.TOKENFILTER;
                                    continue block27;
                                }
                                catch (IllegalArgumentException e2) {
                                    throw new RuntimeException("Line #" + this.lineno(stok) + ": Can't find class '" + argName + "' as CharFilterFactory or TokenizerFactory");
                                }
                            }
                        }
                        className = stok.sval;
                        try {
                            clazz = this.lookupAnalysisClass(className, TokenFilterFactory.class);
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Can't find class '" + className + "' as TokenFilterFactory");
                        }
                        this.createAnalysisPipelineComponent(stok, clazz);
                        continue block27;
                    }
                }
                throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected token: " + stok.toString());
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Line #")) {
                throw e;
            }
            throw new RuntimeException("Line #" + this.lineno(stok) + ": ", e);
        }
        catch (Throwable t) {
            throw new RuntimeException("Line #" + this.lineno(stok) + ": ", t);
        }
        analyzerFactory = new AnalyzerFactory(this.charFilterFactories, this.tokenizerFactory, this.tokenFilterFactories);
        analyzerFactory.setPositionIncrementGap(this.positionIncrementGap);
        analyzerFactory.setOffsetGap(this.offsetGap);
        this.getRunData().getAnalyzerFactories().put(this.factoryName, analyzerFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createAnalysisPipelineComponent(StreamTokenizer stok, Class<? extends AbstractAnalysisFactory> clazz) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        boolean parenthetical = false;
        try {
            AbstractAnalysisFactory instance;
            block16: while (stok.nextToken() != -1) {
                block2 : switch (stok.ttype) {
                    case 44: {
                        if (!parenthetical) break block16;
                        break;
                    }
                    case 40: {
                        if (parenthetical) {
                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected opening parenthesis.");
                        }
                        parenthetical = true;
                        break;
                    }
                    case 41: {
                        if (!parenthetical) throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected closing parenthesis.");
                        parenthetical = false;
                        break;
                    }
                    case -3: {
                        if (!parenthetical) {
                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected token '" + stok.sval + "'");
                        }
                        String argName = stok.sval;
                        stok.nextToken();
                        if (stok.ttype != 58) {
                            throw new RuntimeException("Line #" + this.lineno(stok) + ": Missing ':' after '" + argName + "' param to " + clazz.getSimpleName());
                        }
                        stok.nextToken();
                        String argValue = stok.sval;
                        switch (stok.ttype) {
                            case -2: {
                                argValue = Double.toString(stok.nval);
                                argValue = TRAILING_DOT_ZERO_PATTERN.matcher(argValue).replaceFirst("");
                            }
                            case -3: 
                            case 34: 
                            case 39: {
                                argMap.put(argName, argValue);
                                break block2;
                            }
                            case -1: {
                                throw new RuntimeException("Unexpected EOF: " + stok.toString());
                            }
                        }
                        throw new RuntimeException("Line #" + this.lineno(stok) + ": Unexpected token: " + stok.toString());
                    }
                }
            }
            if (!argMap.containsKey("luceneMatchVersion")) {
                argMap.put("luceneMatchVersion", Version.LATEST.toString());
            }
            try {
                instance = clazz.getConstructor(Map.class).newInstance(argMap);
            }
            catch (Exception e) {
                throw new RuntimeException("Line #" + this.lineno(stok) + ": ", e);
            }
            if (instance instanceof ResourceLoaderAware) {
                Path baseDir = Paths.get(this.getRunData().getConfig().get("work.dir", "work"), new String[0]);
                if (!Files.isDirectory(baseDir, new LinkOption[0])) {
                    baseDir = Paths.get(".", new String[0]);
                }
                ((ResourceLoaderAware)instance).inform((ResourceLoader)new FilesystemResourceLoader(baseDir));
            }
            if (CharFilterFactory.class.isAssignableFrom(clazz)) {
                this.charFilterFactories.add((CharFilterFactory)instance);
                return;
            }
            if (TokenizerFactory.class.isAssignableFrom(clazz)) {
                this.tokenizerFactory = (TokenizerFactory)instance;
                return;
            }
            if (!TokenFilterFactory.class.isAssignableFrom(clazz)) return;
            this.tokenFilterFactories.add((TokenFilterFactory)instance);
            return;
        }
        catch (RuntimeException e) {
            if (!e.getMessage().startsWith("Line #")) throw new RuntimeException("Line #" + this.lineno(stok) + ": ", e);
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Line #" + this.lineno(stok) + ": ", t);
        }
    }

    public <T> Class<? extends T> lookupAnalysisClass(String className, Class<T> expectedType) throws ClassNotFoundException {
        if (className.contains(".")) {
            try {
                return Class.forName(className).asSubclass(expectedType);
            }
            catch (ClassNotFoundException e) {
                try {
                    return Class.forName(LUCENE_ANALYSIS_PACKAGE_PREFIX + className).asSubclass(expectedType);
                }
                catch (ClassNotFoundException e1) {
                    throw new ClassNotFoundException("Can't find class '" + className + "' or '" + LUCENE_ANALYSIS_PACKAGE_PREFIX + className + "'");
                }
            }
        }
        String analysisComponentName = ANALYSIS_COMPONENT_SUFFIX_PATTERN.matcher(className).replaceFirst("");
        if (CharFilterFactory.class.isAssignableFrom(expectedType)) {
            return CharFilterFactory.lookupClass((String)analysisComponentName).asSubclass(expectedType);
        }
        if (TokenizerFactory.class.isAssignableFrom(expectedType)) {
            return TokenizerFactory.lookupClass((String)analysisComponentName).asSubclass(expectedType);
        }
        if (TokenFilterFactory.class.isAssignableFrom(expectedType)) {
            return TokenFilterFactory.lookupClass((String)analysisComponentName).asSubclass(expectedType);
        }
        throw new ClassNotFoundException("Can't find class '" + className + "'");
    }

    @Override
    public boolean supportsParams() {
        return true;
    }

    public int lineno(StreamTokenizer stok) {
        return this.getAlgLineNum() + stok.lineno();
    }

    private static enum ArgType {
        ANALYZER_ARG,
        ANALYZER_ARG_OR_CHARFILTER_OR_TOKENIZER,
        TOKENFILTER;

    }
}

