/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.lucene.benchmark.byTask.feeds.FacetSource;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;

public class RandomFacetSource
extends FacetSource {
    private Random random;
    private int maxDocFacets;
    private int maxFacetDepth;
    private int maxDims;
    private int maxValue;

    public RandomFacetSource() {
        this.maxValue = this.maxDocFacets * this.maxFacetDepth;
    }

    @Override
    public void getNextFacets(List<FacetField> facets) throws NoMoreDataException, IOException {
        facets.clear();
        int numFacets = 1 + this.random.nextInt(this.maxDocFacets);
        for (int i = 0; i < numFacets; ++i) {
            int depth = this.maxFacetDepth == 2 ? 2 : 2 + this.random.nextInt(this.maxFacetDepth - 2);
            String dim = Integer.toString(this.random.nextInt(this.maxDims));
            String[] components = new String[depth - 1];
            for (int k = 0; k < depth - 1; ++k) {
                components[k] = Integer.toString(this.random.nextInt(this.maxValue));
                this.addItem();
            }
            FacetField ff = new FacetField(dim, components);
            facets.add(ff);
            this.addBytes(ff.toString().length());
        }
    }

    @Override
    public void configure(FacetsConfig config) {
        for (int i = 0; i < this.maxDims; ++i) {
            config.setHierarchical(Integer.toString(i), true);
            config.setMultiValued(Integer.toString(i), true);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        this.random = new Random(config.get("rand.seed", 13));
        this.maxDocFacets = config.get("max.doc.facets", 10);
        this.maxDims = config.get("max.doc.facets.dims", 5);
        this.maxFacetDepth = config.get("max.facet.depth", 3);
        if (this.maxFacetDepth < 2) {
            throw new IllegalArgumentException("max.facet.depth must be at least 2; got: " + this.maxFacetDepth);
        }
        this.maxValue = this.maxDocFacets * this.maxFacetDepth;
    }
}

