/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.lucene.benchmark.byTask.feeds.SimpleQueryMaker;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class SimpleSloppyPhraseQueryMaker
extends SimpleQueryMaker {
    @Override
    protected Query[] prepareQueries() throws Exception {
        ArrayList<String> w = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer("Well, this is just some plain text we use for creating the test documents. It used to be a text from an online collection devoted to first aid, but if there was there an (online) lawyers first aid collection with legal advices, \"it\" might have quite probably advised one not to include \"it\"'s text or the text of any other online collection in one's code, unless one has money that one don't need and one is happy to donate for lawyers charity. Anyhow at some point, rechecking the usage of this text, it became uncertain that this text is free to use, because the web site in the disclaimer of he eBook containing that text was not responding anymore, and at the same time, in projGut, searching for first aid no longer found that eBook as well. So here we are, with a perhaps much less interesting text for the test, but oh much much safer. ");
        while (st.hasMoreTokens() && w.size() < 100) {
            w.add(st.nextToken());
        }
        String[] words = w.toArray(new String[0]);
        ArrayList<PhraseQuery> queries = new ArrayList<PhraseQuery>();
        for (int slop = 0; slop < 8; ++slop) {
            for (int qlen = 2; qlen < 6; ++qlen) {
                for (int wd = 0; wd < words.length - qlen - slop; ++wd) {
                    int i;
                    int remainedSlop = slop;
                    PhraseQuery q = new PhraseQuery();
                    q.setSlop(slop);
                    int wind = wd;
                    for (i = 0; i < qlen; ++i) {
                        q.add(new Term("body", words[wind++]));
                        if (remainedSlop <= 0) continue;
                        --remainedSlop;
                        ++wind;
                    }
                    queries.add(q);
                    remainedSlop = slop;
                    q = new PhraseQuery();
                    q.setSlop(slop + 2 * qlen);
                    wind = wd + qlen + remainedSlop - 1;
                    for (i = 0; i < qlen; ++i) {
                        q.add(new Term("body", words[wind--]));
                        if (remainedSlop <= 0) continue;
                        --remainedSlop;
                        --wind;
                    }
                    queries.add(q);
                }
            }
        }
        return queries.toArray(new Query[0]);
    }
}

