/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.utils;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.QualityQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class SimpleQQParser
implements QualityQueryParser {
    private String[] qqNames;
    private String indexField;
    ThreadLocal<QueryParser> queryParser = new ThreadLocal();

    public SimpleQQParser(String[] qqNames, String indexField) {
        this.qqNames = qqNames;
        this.indexField = indexField;
    }

    public SimpleQQParser(String qqName, String indexField) {
        this(new String[]{qqName}, indexField);
    }

    @Override
    public Query parse(QualityQuery qq) throws ParseException {
        QueryParser qp = this.queryParser.get();
        if (qp == null) {
            qp = new QueryParser(this.indexField, (Analyzer)new StandardAnalyzer());
            this.queryParser.set(qp);
        }
        BooleanQuery bq = new BooleanQuery();
        for (int i = 0; i < this.qqNames.length; ++i) {
            bq.add(qp.parse(QueryParserBase.escape((String)qq.getValue(this.qqNames[i]))), BooleanClause.Occur.SHOULD);
        }
        return bq;
    }
}

