/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.lucene.benchmark.byTask.feeds.ContentItemsSource;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.feeds.EnwikiContentSource;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;

public class ExtractWikipedia {
    private File outputDir;
    public static int count = 0;
    static final int BASE = 10;
    protected DocMaker docMaker;

    public ExtractWikipedia(DocMaker docMaker, File outputDir) {
        this.outputDir = outputDir;
        this.docMaker = docMaker;
        System.out.println("Deleting all files in " + outputDir);
        File[] files = outputDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }

    public File directory(int count, File directory) {
        int base;
        if (directory == null) {
            directory = this.outputDir;
        }
        for (base = 10; base <= count; base *= 10) {
        }
        if (count < 10) {
            return directory;
        }
        directory = new File(directory, Integer.toString(base / 10));
        directory = new File(directory, Integer.toString(count / (base / 10)));
        return this.directory(count % (base / 10), directory);
    }

    public void create(String id, String title, String time, String body) {
        File d = this.directory(count++, null);
        d.mkdirs();
        File f = new File(d, id + ".txt");
        StringBuilder contents = new StringBuilder();
        contents.append(time);
        contents.append("\n\n");
        contents.append(title);
        contents.append("\n\n");
        contents.append(body);
        contents.append("\n");
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
            writer.write(contents.toString());
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void extract() throws Exception {
        Document doc = null;
        System.out.println("Starting Extraction");
        long start = System.currentTimeMillis();
        try {
            while ((doc = this.docMaker.makeDocument()) != null) {
                this.create(doc.get("docid"), doc.get("doctitle"), doc.get("docdate"), doc.get("body"));
            }
        }
        catch (NoMoreDataException e) {
            // empty catch block
        }
        long finish = System.currentTimeMillis();
        System.out.println("Extraction took " + (finish - start) + " ms");
    }

    public static void main(String[] args) throws Exception {
        File wikipedia = null;
        File outputDir = new File("./enwiki");
        boolean keepImageOnlyDocs = true;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--input") || arg.equals("-i")) {
                wikipedia = new File(args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("--output") || arg.equals("-o")) {
                outputDir = new File(args[i + 1]);
                ++i;
                continue;
            }
            if (!arg.equals("--discardImageOnlyDocs") && !arg.equals("-d")) continue;
            keepImageOnlyDocs = false;
        }
        Properties properties = new Properties();
        properties.setProperty("docs.file", wikipedia.getAbsolutePath());
        properties.setProperty("content.source.forever", "false");
        properties.setProperty("keep.image.only.docs", String.valueOf(keepImageOnlyDocs));
        Config config = new Config(properties);
        EnwikiContentSource source = new EnwikiContentSource();
        ((ContentItemsSource)source).setConfig(config);
        DocMaker docMaker = new DocMaker();
        docMaker.setConfig(config, source);
        docMaker.resetInputs();
        if (wikipedia.exists()) {
            System.out.println("Extracting Wikipedia to: " + outputDir + " using EnwikiContentSource");
            outputDir.mkdirs();
            ExtractWikipedia extractor = new ExtractWikipedia(docMaker, outputDir);
            extractor.extract();
        } else {
            ExtractWikipedia.printUsage();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: java -cp <...> org.apache.lucene.benchmark.utils.ExtractWikipedia --input|-i <Path to Wikipedia XML file> [--output|-o <Output Path>] [--discardImageOnlyDocs|-d]");
        System.err.println("--discardImageOnlyDocs tells the extractor to skip Wiki docs that contain only images");
    }
}

