/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class DocMaker
implements Closeable {
    private Random r;
    private int updateDocIDLimit;
    private boolean storeBytes = false;
    private ThreadLocal<LeftOver> leftovr = new ThreadLocal();
    private ThreadLocal<DocState> docState = new ThreadLocal();
    private ThreadLocal<DateUtil> dateParsers = new ThreadLocal();
    public static final String BODY_FIELD = "body";
    public static final String TITLE_FIELD = "doctitle";
    public static final String DATE_FIELD = "docdate";
    public static final String DATE_MSEC_FIELD = "docdatenum";
    public static final String TIME_SEC_FIELD = "doctimesecnum";
    public static final String ID_FIELD = "docid";
    public static final String BYTES_FIELD = "bytes";
    public static final String NAME_FIELD = "docname";
    protected Config config;
    protected FieldType valType;
    protected FieldType bodyValType;
    protected ContentSource source;
    protected boolean reuseFields;
    protected boolean indexProperties;
    private final AtomicInteger numDocsCreated = new AtomicInteger();

    private Document createDocument(DocData docData, int size, int cnt) throws UnsupportedEncodingException {
        Properties props;
        int id;
        DocState ds = this.getDocState();
        Document doc = this.reuseFields ? ds.doc : new Document();
        doc.getFields().clear();
        FieldType ft = new FieldType(this.valType);
        ft.setIndexed(true);
        Field idField = ds.getField(ID_FIELD, ft);
        if (this.r != null) {
            id = this.r.nextInt(this.updateDocIDLimit);
        } else {
            id = docData.getID();
            if (id == -1) {
                id = this.numDocsCreated.getAndIncrement();
            }
        }
        idField.setStringValue(Integer.toString(id));
        doc.add((IndexableField)idField);
        String name = docData.getName();
        if (name == null) {
            name = "";
        }
        name = cnt < 0 ? name : name + "_" + cnt;
        Field nameField = ds.getField(NAME_FIELD, this.valType);
        nameField.setStringValue(name);
        doc.add((IndexableField)nameField);
        DateUtil util = this.dateParsers.get();
        if (util == null) {
            util = new DateUtil();
            this.dateParsers.set(util);
        }
        Date date = null;
        String dateString = docData.getDate();
        if (dateString != null) {
            util.pos.setIndex(0);
            date = util.parser.parse(dateString, util.pos);
        } else {
            dateString = "";
        }
        Field dateStringField = ds.getField(DATE_FIELD, this.valType);
        dateStringField.setStringValue(dateString);
        doc.add((IndexableField)dateStringField);
        if (date == null) {
            date = new Date();
        }
        Field dateField = ds.getNumericField(DATE_MSEC_FIELD, FieldType.NumericType.LONG);
        dateField.setLongValue(date.getTime());
        doc.add((IndexableField)dateField);
        util.cal.setTime(date);
        int sec = util.cal.get(11) * 3600 + util.cal.get(12) * 60 + util.cal.get(13);
        Field timeSecField = ds.getNumericField(TIME_SEC_FIELD, FieldType.NumericType.INT);
        timeSecField.setIntValue(sec);
        doc.add((IndexableField)timeSecField);
        String title = docData.getTitle();
        Field titleField = ds.getField(TITLE_FIELD, this.valType);
        titleField.setStringValue(title == null ? "" : title);
        doc.add((IndexableField)titleField);
        String body = docData.getBody();
        if (body != null && body.length() > 0) {
            String bdy;
            if (size <= 0 || size >= body.length()) {
                bdy = body;
                docData.setBody("");
            } else {
                for (int n = size - 1; n < size + 20 && n < body.length(); ++n) {
                    if (!Character.isWhitespace(body.charAt(n))) continue;
                    size = n;
                    break;
                }
                bdy = body.substring(0, size);
                docData.setBody(body.substring(size));
            }
            Field bodyField = ds.getField(BODY_FIELD, this.bodyValType);
            bodyField.setStringValue(bdy);
            doc.add((IndexableField)bodyField);
            if (this.storeBytes) {
                Field bytesField = ds.getField(BYTES_FIELD, StringField.TYPE_STORED);
                bytesField.setBytesValue(bdy.getBytes(StandardCharsets.UTF_8));
                doc.add((IndexableField)bytesField);
            }
        }
        if (this.indexProperties && (props = docData.getProps()) != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Field f = ds.getField((String)entry.getKey(), this.valType);
                f.setStringValue((String)entry.getValue());
                doc.add((IndexableField)f);
            }
            docData.setProps(null);
        }
        return doc;
    }

    private void resetLeftovers() {
        this.leftovr.set(null);
    }

    protected DocState getDocState() {
        DocState ds = this.docState.get();
        if (ds == null) {
            ds = new DocState(this.reuseFields, this.valType, this.bodyValType);
            this.docState.set(ds);
        }
        return ds;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    public Document makeDocument() throws Exception {
        this.resetLeftovers();
        DocData docData = this.source.getNextDocData(this.getDocState().docData);
        Document doc = this.createDocument(docData, 0, -1);
        return doc;
    }

    public Document makeDocument(int size) throws Exception {
        int cnt;
        LeftOver lvr = this.leftovr.get();
        if (lvr == null || lvr.docdata == null || lvr.docdata.getBody() == null || lvr.docdata.getBody().length() == 0) {
            this.resetLeftovers();
        }
        DocData docData = this.getDocState().docData;
        DocData dd = lvr == null ? this.source.getNextDocData(docData) : lvr.docdata;
        int n = cnt = lvr == null ? 0 : lvr.cnt;
        while (dd.getBody() == null || dd.getBody().length() < size) {
            DocData dd2 = dd;
            dd = this.source.getNextDocData(new DocData());
            cnt = 0;
            dd.setBody(dd2.getBody() + dd.getBody());
        }
        Document doc = this.createDocument(dd, size, cnt);
        if (dd.getBody() == null || dd.getBody().length() == 0) {
            this.resetLeftovers();
        } else {
            if (lvr == null) {
                lvr = new LeftOver();
                this.leftovr.set(lvr);
            }
            lvr.docdata = dd;
            lvr.cnt = ++cnt;
        }
        return doc;
    }

    public synchronized void resetInputs() throws IOException {
        this.source.printStatistics("docs");
        this.setConfig(this.config, this.source);
        this.source.resetInputs();
        this.numDocsCreated.set(0);
        this.resetLeftovers();
    }

    public void setConfig(Config config, ContentSource source) {
        this.config = config;
        this.source = source;
        boolean stored = config.get("doc.stored", false);
        boolean bodyStored = config.get("doc.body.stored", stored);
        boolean tokenized = config.get("doc.tokenized", true);
        boolean bodyTokenized = config.get("doc.body.tokenized", tokenized);
        boolean norms = config.get("doc.tokenized.norms", false);
        boolean bodyNorms = config.get("doc.body.tokenized.norms", true);
        boolean termVec = config.get("doc.term.vector", false);
        boolean termVecPositions = config.get("doc.term.vector.positions", false);
        boolean termVecOffsets = config.get("doc.term.vector.offsets", false);
        this.valType = new FieldType(TextField.TYPE_NOT_STORED);
        this.valType.setStored(stored);
        this.valType.setTokenized(tokenized);
        this.valType.setOmitNorms(!norms);
        this.valType.setStoreTermVectors(termVec);
        this.valType.setStoreTermVectorPositions(termVecPositions);
        this.valType.setStoreTermVectorOffsets(termVecOffsets);
        this.valType.freeze();
        this.bodyValType = new FieldType(TextField.TYPE_NOT_STORED);
        this.bodyValType.setStored(bodyStored);
        this.bodyValType.setTokenized(bodyTokenized);
        this.bodyValType.setOmitNorms(!bodyNorms);
        this.bodyValType.setStoreTermVectors(termVec);
        this.bodyValType.setStoreTermVectorPositions(termVecPositions);
        this.bodyValType.setStoreTermVectorOffsets(termVecOffsets);
        this.bodyValType.freeze();
        this.storeBytes = config.get("doc.store.body.bytes", false);
        this.reuseFields = config.get("doc.reuse.fields", true);
        this.docState = new ThreadLocal();
        this.indexProperties = config.get("doc.index.props", false);
        this.updateDocIDLimit = config.get("doc.random.id.limit", -1);
        if (this.updateDocIDLimit != -1) {
            this.r = new Random(179L);
        }
    }

    private static class DateUtil {
        public SimpleDateFormat parser = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.ROOT);
        public Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        public ParsePosition pos = new ParsePosition(0);

        public DateUtil() {
            this.parser.setLenient(true);
        }
    }

    protected static class DocState {
        private final Map<String, Field> fields;
        private final Map<String, Field> numericFields;
        private final boolean reuseFields;
        final Document doc;
        DocData docData = new DocData();

        public DocState(boolean reuseFields, FieldType ft, FieldType bodyFt) {
            this.reuseFields = reuseFields;
            if (reuseFields) {
                this.fields = new HashMap<String, Field>();
                this.numericFields = new HashMap<String, Field>();
                this.fields.put(DocMaker.BODY_FIELD, new Field(DocMaker.BODY_FIELD, "", bodyFt));
                this.fields.put(DocMaker.TITLE_FIELD, new Field(DocMaker.TITLE_FIELD, "", ft));
                this.fields.put(DocMaker.DATE_FIELD, new Field(DocMaker.DATE_FIELD, "", ft));
                this.fields.put(DocMaker.ID_FIELD, (Field)new StringField(DocMaker.ID_FIELD, "", Field.Store.YES));
                this.fields.put(DocMaker.NAME_FIELD, new Field(DocMaker.NAME_FIELD, "", ft));
                this.numericFields.put(DocMaker.DATE_MSEC_FIELD, (Field)new LongField(DocMaker.DATE_MSEC_FIELD, 0L, Field.Store.NO));
                this.numericFields.put(DocMaker.TIME_SEC_FIELD, (Field)new IntField(DocMaker.TIME_SEC_FIELD, 0, Field.Store.NO));
                this.doc = new Document();
            } else {
                this.numericFields = null;
                this.fields = null;
                this.doc = null;
            }
        }

        Field getField(String name, FieldType ft) {
            if (!this.reuseFields) {
                return new Field(name, "", ft);
            }
            Field f = this.fields.get(name);
            if (f == null) {
                f = new Field(name, "", ft);
                this.fields.put(name, f);
            }
            return f;
        }

        Field getNumericField(String name, FieldType.NumericType type) {
            Field f = this.reuseFields ? this.numericFields.get(name) : null;
            if (f == null) {
                switch (type) {
                    case INT: {
                        f = new IntField(name, 0, Field.Store.NO);
                        break;
                    }
                    case LONG: {
                        f = new LongField(name, 0L, Field.Store.NO);
                        break;
                    }
                    case FLOAT: {
                        f = new FloatField(name, 0.0f, Field.Store.NO);
                        break;
                    }
                    case DOUBLE: {
                        f = new DoubleField(name, 0.0, Field.Store.NO);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Cannot get here");
                    }
                }
                if (this.reuseFields) {
                    this.numericFields.put(name, f);
                }
            }
            return f;
        }
    }

    private static class LeftOver {
        private DocData docdata;
        private int cnt;

        private LeftOver() {
        }
    }
}

