/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.Format;

public abstract class ContentItemsSource
implements Closeable {
    private long bytesCount;
    private long totalBytesCount;
    private int itemCount;
    private int totalItemCount;
    private Config config;
    private int lastPrintedNumUniqueTexts = 0;
    private long lastPrintedNumUniqueBytes = 0L;
    private int printNum = 0;
    protected boolean forever;
    protected int logStep;
    protected boolean verbose;
    protected String encoding;

    protected final synchronized void addBytes(long numBytes) {
        this.bytesCount += numBytes;
        this.totalBytesCount += numBytes;
    }

    protected final synchronized void addItem() {
        ++this.itemCount;
        ++this.totalItemCount;
    }

    protected final void collectFiles(File dir, ArrayList<File> files) {
        if (!dir.canRead()) {
            return;
        }
        Object[] dirFiles = dir.listFiles();
        Arrays.sort(dirFiles);
        for (int i = 0; i < dirFiles.length; ++i) {
            Object file = dirFiles[i];
            if (((File)file).isDirectory()) {
                this.collectFiles((File)file, files);
                continue;
            }
            if (!((File)file).canRead()) continue;
            files.add((File)file);
        }
    }

    protected final boolean shouldLog() {
        return this.verbose && this.logStep > 0 && this.itemCount % this.logStep == 0;
    }

    @Override
    public abstract void close() throws IOException;

    public final long getBytesCount() {
        return this.bytesCount;
    }

    public final int getItemsCount() {
        return this.itemCount;
    }

    public final Config getConfig() {
        return this.config;
    }

    public final long getTotalBytesCount() {
        return this.totalBytesCount;
    }

    public final int getTotalItemsCount() {
        return this.totalItemCount;
    }

    public void resetInputs() throws IOException {
        this.bytesCount = 0L;
        this.itemCount = 0;
    }

    public void setConfig(Config config) {
        this.config = config;
        this.forever = config.get("content.source.forever", true);
        this.logStep = config.get("content.source.log.step", 0);
        this.verbose = config.get("content.source.verbose", false);
        this.encoding = config.get("content.source.encoding", null);
    }

    public void printStatistics(String itemsName) {
        long nub;
        if (!this.verbose) {
            return;
        }
        boolean print = false;
        String col = "                  ";
        StringBuilder sb = new StringBuilder();
        String newline = System.getProperty("line.separator");
        sb.append("------------> ").append(this.getClass().getSimpleName()).append(" statistics (").append(this.printNum).append("): ").append(newline);
        int nut = this.getTotalItemsCount();
        if (nut > this.lastPrintedNumUniqueTexts) {
            print = true;
            sb.append("total count of " + itemsName + ": ").append(Format.format(0, nut, col)).append(newline);
            this.lastPrintedNumUniqueTexts = nut;
        }
        if ((nub = this.getTotalBytesCount()) > this.lastPrintedNumUniqueBytes) {
            print = true;
            sb.append("total bytes of " + itemsName + ": ").append(Format.format(0, nub, col)).append(newline);
            this.lastPrintedNumUniqueBytes = nub;
        }
        if (this.getItemsCount() > 0) {
            print = true;
            sb.append("num " + itemsName + " added since last inputs reset:   ").append(Format.format(0, this.getItemsCount(), col)).append(newline);
            sb.append("total bytes added for " + itemsName + " since last inputs reset: ").append(Format.format(0, this.getBytesCount(), col)).append(newline);
        }
        if (print) {
            System.out.println(sb.append(newline).toString());
            ++this.printNum;
        }
    }
}

