/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.feeds.FacetSource;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.stats.Points;
import org.apache.lucene.benchmark.byTask.tasks.NewAnalyzerTask;
import org.apache.lucene.benchmark.byTask.tasks.ReadTask;
import org.apache.lucene.benchmark.byTask.tasks.SearchTask;
import org.apache.lucene.benchmark.byTask.utils.AnalyzerFactory;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.FileUtils;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.IOUtils;

public class PerfRunData
implements Closeable {
    private Points points;
    private Directory directory;
    private Map<String, AnalyzerFactory> analyzerFactories = new HashMap<String, AnalyzerFactory>();
    private Analyzer analyzer;
    private DocMaker docMaker;
    private ContentSource contentSource;
    private FacetSource facetSource;
    private Locale locale;
    private Directory taxonomyDir;
    private TaxonomyWriter taxonomyWriter;
    private TaxonomyReader taxonomyReader;
    private HashMap<Class<? extends ReadTask>, QueryMaker> readTaskQueryMaker;
    private Class<? extends QueryMaker> qmkrClass;
    private DirectoryReader indexReader;
    private IndexSearcher indexSearcher;
    private IndexWriter indexWriter;
    private Config config;
    private long startTimeMillis;
    private final HashMap<String, Object> perfObjects = new HashMap();

    public PerfRunData(Config config) throws Exception {
        this.config = config;
        this.analyzer = NewAnalyzerTask.createAnalyzer(config.get("analyzer", "org.apache.lucene.analysis.standard.StandardAnalyzer"));
        String sourceClass = config.get("content.source", "org.apache.lucene.benchmark.byTask.feeds.SingleDocSource");
        this.contentSource = Class.forName(sourceClass).asSubclass(ContentSource.class).newInstance();
        this.contentSource.setConfig(config);
        this.docMaker = Class.forName(config.get("doc.maker", "org.apache.lucene.benchmark.byTask.feeds.DocMaker")).asSubclass(DocMaker.class).newInstance();
        this.docMaker.setConfig(config, this.contentSource);
        this.facetSource = Class.forName(config.get("facet.source", "org.apache.lucene.benchmark.byTask.feeds.RandomFacetSource")).asSubclass(FacetSource.class).newInstance();
        this.facetSource.setConfig(config);
        this.readTaskQueryMaker = new HashMap();
        this.qmkrClass = Class.forName(config.get("query.maker", "org.apache.lucene.benchmark.byTask.feeds.SimpleQueryMaker")).asSubclass(QueryMaker.class);
        this.reinit(false);
        this.points = new Points(config);
        if (Boolean.valueOf(config.get("log.queries", "false")).booleanValue()) {
            System.out.println("------------> queries:");
            System.out.println(this.getQueryMaker(new SearchTask(this)).printQueries());
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.indexWriter, this.indexReader, this.directory, this.taxonomyWriter, this.taxonomyReader, this.taxonomyDir, this.docMaker, this.facetSource, this.contentSource});
        ArrayList<Closeable> perfObjectsToClose = new ArrayList<Closeable>();
        for (Object obj : this.perfObjects.values()) {
            if (!(obj instanceof Closeable)) continue;
            perfObjectsToClose.add((Closeable)obj);
        }
        IOUtils.close(perfObjectsToClose);
    }

    public void reinit(boolean eraseIndex) throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.indexWriter, this.indexReader, this.directory});
        this.indexWriter = null;
        this.indexReader = null;
        IOUtils.close((Closeable[])new Closeable[]{this.taxonomyWriter, this.taxonomyReader, this.taxonomyDir});
        this.taxonomyWriter = null;
        this.taxonomyReader = null;
        this.directory = this.createDirectory(eraseIndex, "index", "directory");
        this.taxonomyDir = this.createDirectory(eraseIndex, "taxo", "taxonomy.directory");
        this.resetInputs();
        System.runFinalization();
        System.gc();
        this.setStartTimeMillis();
    }

    private Directory createDirectory(boolean eraseIndex, String dirName, String dirParam) throws IOException {
        if ("FSDirectory".equals(this.config.get(dirParam, "RAMDirectory"))) {
            File workDir = new File(this.config.get("work.dir", "work"));
            File indexDir = new File(workDir, dirName);
            if (eraseIndex && indexDir.exists()) {
                FileUtils.fullyDelete(indexDir);
            }
            indexDir.mkdirs();
            return FSDirectory.open((File)indexDir);
        }
        return new RAMDirectory();
    }

    public synchronized Object getPerfObject(String key) {
        return this.perfObjects.get(key);
    }

    public synchronized void setPerfObject(String key, Object obj) {
        this.perfObjects.put(key, obj);
    }

    public long setStartTimeMillis() {
        this.startTimeMillis = System.currentTimeMillis();
        return this.startTimeMillis;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public Points getPoints() {
        return this.points;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public Directory getTaxonomyDir() {
        return this.taxonomyDir;
    }

    public synchronized void setTaxonomyReader(TaxonomyReader taxoReader) throws IOException {
        if (taxoReader == this.taxonomyReader) {
            return;
        }
        if (this.taxonomyReader != null) {
            this.taxonomyReader.decRef();
        }
        if (taxoReader != null) {
            taxoReader.incRef();
        }
        this.taxonomyReader = taxoReader;
    }

    public synchronized TaxonomyReader getTaxonomyReader() {
        if (this.taxonomyReader != null) {
            this.taxonomyReader.incRef();
        }
        return this.taxonomyReader;
    }

    public void setTaxonomyWriter(TaxonomyWriter taxoWriter) {
        this.taxonomyWriter = taxoWriter;
    }

    public TaxonomyWriter getTaxonomyWriter() {
        return this.taxonomyWriter;
    }

    public synchronized DirectoryReader getIndexReader() {
        if (this.indexReader != null) {
            this.indexReader.incRef();
        }
        return this.indexReader;
    }

    public synchronized IndexSearcher getIndexSearcher() {
        if (this.indexReader != null) {
            this.indexReader.incRef();
        }
        return this.indexSearcher;
    }

    public synchronized void setIndexReader(DirectoryReader indexReader) throws IOException {
        if (indexReader == this.indexReader) {
            return;
        }
        if (this.indexReader != null) {
            this.indexReader.decRef();
        }
        this.indexReader = indexReader;
        if (indexReader != null) {
            indexReader.incRef();
            this.indexSearcher = new IndexSearcher((IndexReader)indexReader);
        } else {
            this.indexSearcher = null;
        }
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public void setIndexWriter(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public ContentSource getContentSource() {
        return this.contentSource;
    }

    public DocMaker getDocMaker() {
        return this.docMaker;
    }

    public FacetSource getFacetSource() {
        return this.facetSource;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Config getConfig() {
        return this.config;
    }

    public void resetInputs() throws IOException {
        this.contentSource.resetInputs();
        this.docMaker.resetInputs();
        this.facetSource.resetInputs();
        for (QueryMaker queryMaker : this.readTaskQueryMaker.values()) {
            queryMaker.resetInputs();
        }
    }

    public synchronized QueryMaker getQueryMaker(ReadTask readTask) {
        Class<?> readTaskClass = readTask.getClass();
        QueryMaker qm = this.readTaskQueryMaker.get(readTaskClass);
        if (qm == null) {
            try {
                qm = this.qmkrClass.newInstance();
                qm.setConfig(this.config);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.readTaskQueryMaker.put(readTaskClass, qm);
        }
        return qm;
    }

    public Map<String, AnalyzerFactory> getAnalyzerFactories() {
        return this.analyzerFactories;
    }
}

