/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;

public class SpatialDocMaker
extends DocMaker {
    public static final String SPATIAL_FIELD = "spatial";
    private static Map<Integer, SpatialStrategy> spatialStrategyCache = new HashMap<Integer, SpatialStrategy>();
    private SpatialStrategy strategy;
    private ShapeConverter shapeConverter;

    public static SpatialStrategy getSpatialStrategy(int roundNumber) {
        SpatialStrategy result = spatialStrategyCache.get(roundNumber);
        if (result == null) {
            throw new IllegalStateException("Strategy should have been init'ed by SpatialDocMaker by now");
        }
        return result;
    }

    protected SpatialStrategy makeSpatialStrategy(final Config config) {
        AbstractMap<String, String> configMap = new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String get(Object key) {
                return config.get("spatial." + key, null);
            }
        };
        SpatialContext ctx = SpatialContextFactory.makeSpatialContext((Map)configMap, null);
        return this.makeSpatialStrategy(config, (Map<String, String>)configMap, ctx);
    }

    protected SpatialStrategy makeSpatialStrategy(final Config config, Map<String, String> configMap, SpatialContext ctx) {
        SpatialPrefixTree grid = SpatialPrefixTreeFactory.makeSPT(configMap, null, (SpatialContext)ctx);
        RecursivePrefixTreeStrategy strategy = new RecursivePrefixTreeStrategy(grid, SPATIAL_FIELD){
            {
                super(x0, x1);
                this.pointsOnly = config.get("spatial.docPointsOnly", false);
            }
        };
        int prefixGridScanLevel = config.get("query.spatial.prefixGridScanLevel", -4);
        if (prefixGridScanLevel < 0) {
            prefixGridScanLevel = grid.getMaxLevels() + prefixGridScanLevel;
        }
        strategy.setPrefixGridScanLevel(prefixGridScanLevel);
        double distErrPct = config.get("spatial.distErrPct", 0.025);
        strategy.setDistErrPct(distErrPct);
        return strategy;
    }

    @Override
    public void setConfig(Config config, ContentSource source) {
        super.setConfig(config, source);
        SpatialStrategy existing = spatialStrategyCache.get(config.getRoundNumber());
        if (existing == null) {
            this.strategy = this.makeSpatialStrategy(config);
            spatialStrategyCache.put(config.getRoundNumber(), this.strategy);
            this.shapeConverter = SpatialDocMaker.makeShapeConverter(this.strategy, config, "doc.spatial.");
            System.out.println("Spatial Strategy: " + this.strategy);
        }
    }

    public static ShapeConverter makeShapeConverter(final SpatialStrategy spatialStrategy, Config config, String configKeyPrefix) {
        final double radiusDegrees = config.get(configKeyPrefix + "radiusDegrees", 0.0);
        final double plusMinus = config.get(configKeyPrefix + "radiusDegreesRandPlusMinus", 0.0);
        final boolean bbox = config.get(configKeyPrefix + "bbox", false);
        return new ShapeConverter(){

            @Override
            public Shape convert(Shape shape) {
                if (shape instanceof Point && (radiusDegrees != 0.0 || plusMinus != 0.0)) {
                    Point point = (Point)shape;
                    double radius = radiusDegrees;
                    if (plusMinus > 0.0) {
                        Random random = new Random(point.hashCode());
                        radius += random.nextDouble() * 2.0 * plusMinus - plusMinus;
                        radius = Math.abs(radius);
                    }
                    shape = spatialStrategy.getSpatialContext().makeCircle(point, radius);
                }
                if (bbox) {
                    shape = shape.getBoundingBox();
                }
                return shape;
            }
        };
    }

    @Override
    public Document makeDocument() throws Exception {
        DocMaker.DocState docState = this.getDocState();
        Document doc = super.makeDocument();
        DocData docData = docState.docData;
        String shapeStr = doc.getField("body").stringValue();
        Shape shape = SpatialDocMaker.makeShapeFromString(this.strategy, docData.getName(), shapeStr);
        if (shape != null) {
            shape = this.shapeConverter.convert(shape);
            for (Field f : this.strategy.createIndexableFields(shape)) {
                doc.add((IndexableField)f);
            }
        }
        return doc;
    }

    public static Shape makeShapeFromString(SpatialStrategy strategy, String name, String shapeStr) {
        if (shapeStr != null && shapeStr.length() > 0) {
            try {
                return strategy.getSpatialContext().readShapeFromWkt(shapeStr);
            }
            catch (Exception e) {
                System.err.println("Shape " + name + " wasn't parseable: " + e + "  (skipping it)");
                return null;
            }
        }
        return null;
    }

    @Override
    public Document makeDocument(int size) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static interface ShapeConverter {
        public Shape convert(Shape var1);
    }
}

