/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.lucene.benchmark.byTask.feeds.FacetSource;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class RandomFacetSource
extends FacetSource {
    private Random random;
    private int maxDocFacets;
    private int maxFacetDepth;
    private int maxValue;

    public RandomFacetSource() {
        this.maxValue = this.maxDocFacets * this.maxFacetDepth;
    }

    @Override
    public void getNextFacets(List<CategoryPath> facets) throws NoMoreDataException, IOException {
        facets.clear();
        int numFacets = 1 + this.random.nextInt(this.maxDocFacets);
        for (int i = 0; i < numFacets; ++i) {
            int depth = 1 + this.random.nextInt(this.maxFacetDepth);
            String[] components = new String[depth];
            for (int k = 0; k < depth; ++k) {
                components[k] = Integer.toString(this.random.nextInt(this.maxValue));
                this.addItem();
            }
            CategoryPath cp = new CategoryPath(components);
            facets.add(cp);
            this.addBytes(cp.toString().length());
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        this.random = new Random(config.get("rand.seed", 13));
        this.maxDocFacets = config.get("max.doc.facets", 10);
        this.maxFacetDepth = config.get("max.facet.depth", 3);
        this.maxValue = this.maxDocFacets * this.maxFacetDepth;
    }
}

