/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;

public class ReadTokensTask
extends PerfTask {
    private int totalTokenCount = 0;
    private Document doc = null;
    ReusableStringReader stringReader = new ReusableStringReader();

    public ReadTokensTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = docMaker.makeDocument();
    }

    @Override
    protected String getLogMessage(int recsCount) {
        return "read " + recsCount + " docs; " + this.totalTokenCount + " tokens";
    }

    @Override
    public void tearDown() throws Exception {
        this.doc = null;
        super.tearDown();
    }

    @Override
    public int doLogic() throws Exception {
        List fields = this.doc.getFields();
        Analyzer analyzer = this.getRunData().getAnalyzer();
        int tokenCount = 0;
        for (IndexableField field : fields) {
            if (!field.fieldType().tokenized() || field instanceof IntField || field instanceof LongField || field instanceof FloatField || field instanceof DoubleField) continue;
            TokenStream stream = field.tokenStream(analyzer);
            stream.reset();
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            while (stream.incrementToken()) {
                termAtt.fillBytesRef();
                ++tokenCount;
            }
            stream.end();
            stream.close();
        }
        this.totalTokenCount += tokenCount;
        return tokenCount;
    }

    private static final class ReusableStringReader
    extends Reader {
        int upto;
        int left;
        String s;

        private ReusableStringReader() {
        }

        void init(String s) {
            this.s = s;
            this.left = s.length();
            this.upto = 0;
        }

        @Override
        public int read(char[] c) {
            return this.read(c, 0, c.length);
        }

        @Override
        public int read(char[] c, int off, int len) {
            if (this.left > len) {
                this.s.getChars(this.upto, this.upto + len, c, off);
                this.upto += len;
                this.left -= len;
                return len;
            }
            if (0 == this.left) {
                return -1;
            }
            this.s.getChars(this.upto, this.upto + this.left, c, off);
            int r = this.left;
            this.left = 0;
            this.upto = this.s.length();
            return r;
        }

        @Override
        public void close() {
        }
    }
}

