/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.WriteLineDocTask;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

public class WriteEnwikiLineDocTask
extends WriteLineDocTask {
    private final PrintWriter categoryLineFileOut;

    public WriteEnwikiLineDocTask(PerfRunData runData) throws Exception {
        super(runData);
        OutputStream out = StreamUtils.outputStream(WriteEnwikiLineDocTask.categoriesLineFile(new File(this.fname)));
        this.categoryLineFileOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8), 65536));
        this.writeHeader(this.categoryLineFileOut);
    }

    public static File categoriesLineFile(File f) {
        File dir = f.getParentFile();
        String categoriesName = "categories-" + f.getName();
        return dir == null ? new File(categoriesName) : new File(dir, categoriesName);
    }

    @Override
    public void close() throws Exception {
        this.categoryLineFileOut.close();
        super.close();
    }

    @Override
    protected PrintWriter lineFileOut(Document doc) {
        IndexableField titleField = doc.getField("doctitle");
        if (titleField != null && titleField.stringValue().startsWith("Category:")) {
            return this.categoryLineFileOut;
        }
        return super.lineFileOut(doc);
    }
}

