/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.tasks.RepSumByPrefTask;
import org.apache.lucene.benchmark.byTask.tasks.TaskSequence;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class Algorithm {
    private TaskSequence sequence;
    private final String[] taskPackages;

    public Algorithm(PerfRunData runData) throws Exception {
        PerfTask p;
        ArrayList<PerfTask> t;
        Config config = runData.getConfig();
        this.taskPackages = this.initTasksPackages(config);
        String algTxt = config.getAlgorithmText();
        TaskSequence currSequence = this.sequence = new TaskSequence(runData, null, null, false);
        PerfTask prevTask = null;
        StreamTokenizer stok = new StreamTokenizer(new StringReader(algTxt));
        stok.commentChar(35);
        stok.eolIsSignificant(false);
        stok.ordinaryChar(34);
        stok.ordinaryChar(47);
        stok.ordinaryChar(40);
        stok.ordinaryChar(41);
        boolean colonOk = false;
        boolean isDisableCountNextTask = false;
        currSequence.setDepth(0);
        block16: while (stok.nextToken() != -1) {
            switch (stok.ttype) {
                case -3: {
                    String s = stok.sval;
                    Constructor<PerfTask> cnstr = this.taskClass(config, s).asSubclass(PerfTask.class).getConstructor(PerfRunData.class);
                    PerfTask task = cnstr.newInstance(runData);
                    task.setDisableCounting(isDisableCountNextTask);
                    isDisableCountNextTask = false;
                    currSequence.addTask(task);
                    if (task instanceof RepSumByPrefTask) {
                        stok.nextToken();
                        String prefix = stok.sval;
                        if (prefix == null || prefix.length() == 0) {
                            throw new Exception("named report prefix problem - " + stok.toString());
                        }
                        ((RepSumByPrefTask)task).setPrefix(prefix);
                    }
                    stok.nextToken();
                    if (stok.ttype != 40) {
                        stok.pushBack();
                    } else {
                        StringBuilder params = new StringBuilder();
                        stok.nextToken();
                        while (stok.ttype != 41) {
                            switch (stok.ttype) {
                                case -2: {
                                    params.append(stok.nval);
                                    break;
                                }
                                case -3: {
                                    params.append(stok.sval);
                                    break;
                                }
                                case -1: {
                                    throw new Exception("unexpexted EOF: - " + stok.toString());
                                }
                                default: {
                                    params.append((char)stok.ttype);
                                }
                            }
                            stok.nextToken();
                        }
                        String prm = params.toString().trim();
                        if (prm.length() > 0) {
                            task.setParams(prm);
                        }
                    }
                    colonOk = false;
                    prevTask = task;
                    continue block16;
                }
            }
            char c = (char)stok.ttype;
            switch (c) {
                case ':': {
                    if (!colonOk) {
                        throw new Exception("colon unexpexted: - " + stok.toString());
                    }
                    colonOk = false;
                    stok.nextToken();
                    if ((char)stok.ttype == '*') {
                        ((TaskSequence)prevTask).setRepetitions(TaskSequence.REPEAT_EXHAUST);
                    } else {
                        if (stok.ttype != -2) {
                            throw new Exception("expected repetitions number or XXXs: - " + stok.toString());
                        }
                        double num = stok.nval;
                        stok.nextToken();
                        if (stok.ttype == -3 && stok.sval.equals("s")) {
                            ((TaskSequence)prevTask).setRunTime(num);
                        } else {
                            stok.pushBack();
                            ((TaskSequence)prevTask).setRepetitions((int)num);
                        }
                    }
                    stok.nextToken();
                    if (stok.ttype != 58) {
                        stok.pushBack();
                    } else {
                        stok.nextToken();
                        if (stok.ttype != -2) {
                            throw new Exception("expected rate number: - " + stok.toString());
                        }
                        stok.nextToken();
                        if (stok.ttype != 47) {
                            stok.pushBack();
                            ((TaskSequence)prevTask).setRate((int)stok.nval, false);
                        } else {
                            stok.nextToken();
                            if (stok.ttype != -3) {
                                throw new Exception("expected rate unit: 'min' or 'sec' - " + stok.toString());
                            }
                            String unit = stok.sval.toLowerCase(Locale.ROOT);
                            if ("min".equals(unit)) {
                                ((TaskSequence)prevTask).setRate((int)stok.nval, true);
                            } else if ("sec".equals(unit)) {
                                ((TaskSequence)prevTask).setRate((int)stok.nval, false);
                            } else {
                                throw new Exception("expected rate unit: 'min' or 'sec' - " + stok.toString());
                            }
                        }
                    }
                    colonOk = false;
                    break;
                }
                case '[': 
                case '{': {
                    String name = null;
                    stok.nextToken();
                    if (stok.ttype != 34) {
                        stok.pushBack();
                    } else {
                        stok.nextToken();
                        name = stok.sval;
                        stok.nextToken();
                        if (stok.ttype != 34 || name == null || name.length() == 0) {
                            throw new Exception("sequence name problem - " + stok.toString());
                        }
                    }
                    TaskSequence seq2 = new TaskSequence(runData, name, currSequence, c == '[');
                    currSequence.addTask(seq2);
                    currSequence = seq2;
                    colonOk = false;
                    break;
                }
                case '&': {
                    int deltaPri;
                    if (currSequence.isParallel()) {
                        throw new Exception("Can only create background tasks within a serial task");
                    }
                    stok.nextToken();
                    if (stok.ttype != -2) {
                        stok.pushBack();
                        deltaPri = 0;
                    } else {
                        deltaPri = (int)stok.nval;
                    }
                    if (prevTask == null) {
                        throw new Exception("& was unexpected");
                    }
                    if (prevTask.getRunInBackground()) {
                        throw new Exception("double & was unexpected");
                    }
                    prevTask.setRunInBackground(deltaPri);
                    break;
                }
                case '>': {
                    currSequence.setNoChildReport();
                }
                case ']': 
                case '}': {
                    colonOk = true;
                    prevTask = currSequence;
                    currSequence = currSequence.getParent();
                    break;
                }
                case '-': {
                    isDisableCountNextTask = true;
                }
            }
        }
        if (this.sequence != currSequence) {
            throw new Exception("Unmatched sequences");
        }
        while (this.sequence.isCollapsable() && this.sequence.getRepetitions() == 1 && this.sequence.getRate() == 0 && (t = this.sequence.getTasks()) != null && t.size() == 1 && (p = t.get(0)) instanceof TaskSequence) {
            this.sequence = (TaskSequence)p;
        }
    }

    private String[] initTasksPackages(Config config) {
        String alts = config.get("alt.tasks.packages", null);
        String dfltPkg = PerfTask.class.getPackage().getName();
        if (alts == null) {
            return new String[]{dfltPkg};
        }
        ArrayList<String> pkgs = new ArrayList<String>();
        pkgs.add(dfltPkg);
        for (String alt : alts.split(",")) {
            pkgs.add(alt);
        }
        return pkgs.toArray(new String[0]);
    }

    private Class<?> taskClass(Config config, String taskName) throws ClassNotFoundException {
        for (String pkg : this.taskPackages) {
            try {
                return Class.forName(pkg + '.' + taskName + "Task");
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(taskName + " not found in packages " + Arrays.toString(this.taskPackages));
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(this.sequence.toString());
        sb.append(newline);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        try {
            this.sequence.runAndMaybeStats(true);
        }
        finally {
            this.sequence.close();
        }
    }

    public ArrayList<PerfTask> extractTasks() {
        ArrayList<PerfTask> res = new ArrayList<PerfTask>();
        this.extractTasks(res, this.sequence);
        return res;
    }

    private void extractTasks(ArrayList<PerfTask> extrct, TaskSequence seq) {
        if (seq == null) {
            return;
        }
        extrct.add(seq);
        ArrayList<PerfTask> t = this.sequence.getTasks();
        if (t == null) {
            return;
        }
        for (PerfTask p : t) {
            if (p instanceof TaskSequence) {
                this.extractTasks(extrct, (TaskSequence)p);
                continue;
            }
            extrct.add(p);
        }
    }
}

