/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.NewAnalyzerTask;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;

public class NewShingleAnalyzerTask
extends PerfTask {
    private String analyzerClassName = "standard.StandardAnalyzer";
    private int maxShingleSize = 2;
    private boolean outputUnigrams = true;

    public NewShingleAnalyzerTask(PerfRunData runData) {
        super(runData);
    }

    private void setAnalyzer() throws Exception {
        Analyzer wrappedAnalyzer = null;
        if (null == this.analyzerClassName || 0 == this.analyzerClassName.length()) {
            this.analyzerClassName = "org.apache.lucene.analysis.standard.StandardAnalyzer";
        }
        if (-1 == this.analyzerClassName.indexOf(".")) {
            String coreClassName = "org.apache.lucene.analysis.core." + this.analyzerClassName;
            try {
                wrappedAnalyzer = NewAnalyzerTask.createAnalyzer(coreClassName);
                this.analyzerClassName = coreClassName;
            }
            catch (ClassNotFoundException e) {
                this.analyzerClassName = "org.apache.lucene.analysis." + this.analyzerClassName;
                wrappedAnalyzer = NewAnalyzerTask.createAnalyzer(this.analyzerClassName);
            }
        } else {
            if (this.analyzerClassName.startsWith("standard.")) {
                this.analyzerClassName = "org.apache.lucene.analysis." + this.analyzerClassName;
            }
            wrappedAnalyzer = NewAnalyzerTask.createAnalyzer(this.analyzerClassName);
        }
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper(wrappedAnalyzer, 2, this.maxShingleSize, " ", this.outputUnigrams, false);
        this.getRunData().setAnalyzer((Analyzer)analyzer);
    }

    @Override
    public int doLogic() throws Exception {
        try {
            this.setAnalyzer();
            System.out.println("Changed Analyzer to: ShingleAnalyzerWrapper, wrapping ShingleFilter over " + this.analyzerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Analyzer", e);
        }
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        StringTokenizer st = new StringTokenizer(params, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            StringTokenizer expr = new StringTokenizer(param, ":");
            String key = expr.nextToken();
            String value = expr.nextToken();
            if (key.equalsIgnoreCase("analyzer")) {
                this.analyzerClassName = value;
                continue;
            }
            if (key.equalsIgnoreCase("outputUnigrams")) {
                this.outputUnigrams = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equalsIgnoreCase("maxShingleSize")) {
                this.maxShingleSize = (int)Double.parseDouble(value);
                continue;
            }
            throw new RuntimeException("Unknown parameter " + param);
        }
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

