/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.AddDocTask;
import org.apache.lucene.facet.associations.CategoryAssociationsContainer;
import org.apache.lucene.facet.index.FacetFields;

public class AddFacetedDocTask
extends AddDocTask {
    private CategoryAssociationsContainer facets = null;
    private FacetFields facetFields = null;
    private boolean withFacets = true;

    public AddFacetedDocTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.facets = this.getRunData().getFacetSource().getNextFacets(this.facets);
        this.withFacets = this.getRunData().getConfig().get("with.facets", true);
        if (this.withFacets) {
            this.facetFields = new FacetFields(this.getRunData().getTaxonomyWriter());
        }
    }

    @Override
    protected String getLogMessage(int recsCount) {
        if (!this.withFacets) {
            return super.getLogMessage(recsCount);
        }
        return super.getLogMessage(recsCount) + " with facets";
    }

    @Override
    public int doLogic() throws Exception {
        if (this.withFacets) {
            this.facetFields.addFields(this.doc, (Iterable)this.facets);
        }
        return super.doLogic();
    }
}

