/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class EnwikiContentSource
extends ContentSource {
    private static final Map<String, Integer> ELEMENTS = new HashMap<String, Integer>();
    private static final int TITLE = 0;
    private static final int DATE = 1;
    private static final int BODY = 2;
    private static final int ID = 3;
    private static final int LENGTH = 4;
    private static final int PAGE = 5;
    private static final String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private File file;
    private boolean keepImages = true;
    private InputStream is;
    private Parser parser = new Parser();

    private static final int getElementType(String elem) {
        Integer val = ELEMENTS.get(elem);
        return val == null ? -1 : val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        EnwikiContentSource enwikiContentSource = this;
        synchronized (enwikiContentSource) {
            this.parser.stop();
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }
    }

    @Override
    public synchronized DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        String[] tuple = this.parser.next();
        docData.clear();
        docData.setName(tuple[3]);
        docData.setBody(tuple[2]);
        docData.setDate(tuple[1]);
        docData.setTitle(tuple[0]);
        return docData;
    }

    @Override
    public void resetInputs() throws IOException {
        super.resetInputs();
        this.is = this.openInputStream();
    }

    protected InputStream openInputStream() throws IOException {
        return StreamUtils.inputStream(this.file);
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        this.keepImages = config.get("keep.image.only.docs", true);
        String fileName = config.get("docs.file", null);
        if (fileName != null) {
            this.file = new File(fileName).getAbsoluteFile();
        }
    }

    static {
        ELEMENTS.put("page", 5);
        ELEMENTS.put("text", 2);
        ELEMENTS.put("timestamp", 1);
        ELEMENTS.put("title", 0);
        ELEMENTS.put("id", 3);
    }

    private class Parser
    extends DefaultHandler
    implements Runnable {
        private Thread t;
        private boolean threadDone;
        private boolean stopped = false;
        private String[] tuple;
        private NoMoreDataException nmde;
        private StringBuilder contents = new StringBuilder();
        private String title;
        private String body;
        private String time;
        private String id;

        private Parser() {
        }

        String[] next() throws NoMoreDataException {
            if (this.t == null) {
                this.threadDone = false;
                this.t = new Thread(this);
                this.t.setDaemon(true);
                this.t.start();
            }
            Parser parser = this;
            synchronized (parser) {
                while (this.tuple == null && this.nmde == null && !this.threadDone && !this.stopped) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw new ThreadInterruptedException(ie);
                    }
                }
                if (this.tuple != null) {
                    String[] result = this.tuple;
                    this.tuple = null;
                    this.notify();
                    return result;
                }
                if (this.nmde != null) {
                    this.t = null;
                    throw this.nmde;
                }
                throw new NoMoreDataException();
            }
        }

        String time(String original) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(original.substring(8, 10));
            buffer.append('-');
            buffer.append(months[Integer.valueOf(original.substring(5, 7)) - 1]);
            buffer.append('-');
            buffer.append(original.substring(0, 4));
            buffer.append(' ');
            buffer.append(original.substring(11, 19));
            buffer.append(".000");
            return buffer.toString();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.contents.append(ch, start, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String namespace, String simple, String qualified) throws SAXException {
            int elemType = EnwikiContentSource.getElementType(qualified);
            switch (elemType) {
                case 5: {
                    if (this.body == null || !EnwikiContentSource.this.keepImages && this.title.startsWith("Image:")) break;
                    String[] tmpTuple = new String[]{this.title.replace('\t', ' '), this.time.replace('\t', ' '), this.body.replaceAll("[\t\n]", " "), this.id};
                    Parser parser = this;
                    synchronized (parser) {
                        while (this.tuple != null && !this.stopped) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                throw new ThreadInterruptedException(ie);
                            }
                        }
                        this.tuple = tmpTuple;
                        this.notify();
                        break;
                    }
                }
                case 2: {
                    this.body = this.contents.toString();
                    String startsWith = this.body.substring(0, Math.min(10, this.contents.length())).toLowerCase(Locale.ROOT);
                    if (!startsWith.startsWith("#redirect")) break;
                    this.body = null;
                    break;
                }
                case 1: {
                    this.time = this.time(this.contents.toString());
                    break;
                }
                case 0: {
                    this.title = this.contents.toString();
                    break;
                }
                case 3: {
                    if (this.id != null) break;
                    this.id = this.contents.toString();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(this);
                reader.setErrorHandler(this);
                while (!this.stopped) {
                    InputStream localFileIS = EnwikiContentSource.this.is;
                    if (localFileIS != null) {
                        try {
                            CharsetDecoder decoder = IOUtils.CHARSET_UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                            reader.parse(new InputSource(new BufferedReader(new InputStreamReader(localFileIS, decoder))));
                        }
                        catch (IOException ioe) {
                            EnwikiContentSource enwikiContentSource = EnwikiContentSource.this;
                            synchronized (enwikiContentSource) {
                                if (localFileIS == EnwikiContentSource.this.is) throw ioe;
                            }
                        }
                    }
                    Parser parser = this;
                    synchronized (parser) {
                        if (this.stopped || !EnwikiContentSource.this.forever) {
                            this.nmde = new NoMoreDataException();
                            this.notify();
                            return;
                        }
                        if (localFileIS == EnwikiContentSource.this.is) {
                            EnwikiContentSource.this.is = EnwikiContentSource.this.openInputStream();
                        }
                    }
                }
                return;
            }
            catch (SAXException sae) {
                throw new RuntimeException(sae);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                Parser parser = this;
                synchronized (parser) {
                    this.threadDone = true;
                    this.notify();
                }
            }
        }

        @Override
        public void startElement(String namespace, String simple, String qualified, Attributes attributes) {
            int elemType = EnwikiContentSource.getElementType(qualified);
            switch (elemType) {
                case 5: {
                    this.title = null;
                    this.body = null;
                    this.time = null;
                    this.id = null;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.contents.setLength(0);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            Parser parser = this;
            synchronized (parser) {
                this.stopped = true;
                if (this.tuple != null) {
                    this.tuple = null;
                    this.notify();
                }
            }
        }
    }
}

