/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.AddDocTask;
import org.apache.lucene.facet.index.CategoryContainer;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;

public class AddFacetedDocTask
extends AddDocTask {
    private CategoryContainer facets = null;
    private CategoryDocumentBuilder categoryDocBuilder = null;
    private boolean withFacets = true;

    public AddFacetedDocTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        this.facets = this.getRunData().getFacetSource().getNextFacets(this.facets);
        this.withFacets = this.getRunData().getConfig().get("with.facets", true);
        if (this.withFacets) {
            this.categoryDocBuilder = new CategoryDocumentBuilder(this.getRunData().getTaxonomyWriter());
            this.categoryDocBuilder.setCategories((Iterable)this.facets);
        }
    }

    @Override
    protected String getLogMessage(int recsCount) {
        if (!this.withFacets) {
            return super.getLogMessage(recsCount);
        }
        return super.getLogMessage(recsCount) + " with facets";
    }

    @Override
    public int doLogic() throws Exception {
        if (this.withFacets) {
            this.categoryDocBuilder.build(this.doc);
        }
        return super.doLogic();
    }
}

