/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.stats;

import org.apache.lucene.benchmark.byTask.tasks.PerfTask;

public class TaskStats
implements Cloneable {
    private PerfTask task;
    private int round;
    private long start;
    private long elapsed = -1L;
    private long maxTotMem;
    private long maxUsedMem;
    private int taskRunNum;
    private int numParallelTasks;
    private int count;
    private int numRuns = 1;
    private int[] countsByTime;
    private long countsByTimeStepMSec;

    TaskStats(PerfTask task, int taskRunNum, int round) {
        this.task = task;
        this.taskRunNum = taskRunNum;
        this.round = round;
        this.maxTotMem = Runtime.getRuntime().totalMemory();
        this.maxUsedMem = this.maxTotMem - Runtime.getRuntime().freeMemory();
        this.start = System.currentTimeMillis();
    }

    void markEnd(int numParallelTasks, int count) {
        long usedMem;
        this.elapsed = System.currentTimeMillis() - this.start;
        long totMem = Runtime.getRuntime().totalMemory();
        if (totMem > this.maxTotMem) {
            this.maxTotMem = totMem;
        }
        if ((usedMem = totMem - Runtime.getRuntime().freeMemory()) > this.maxUsedMem) {
            this.maxUsedMem = usedMem;
        }
        this.numParallelTasks = numParallelTasks;
        this.count = count;
    }

    public void setCountsByTime(int[] counts, long msecStep) {
        this.countsByTime = counts;
        this.countsByTimeStepMSec = msecStep;
    }

    public int[] getCountsByTime() {
        return this.countsByTime;
    }

    public long getCountsByTimeStepMSec() {
        return this.countsByTimeStepMSec;
    }

    public int getTaskRunNum() {
        return this.taskRunNum;
    }

    public String toString() {
        StringBuilder res = new StringBuilder(this.task.getName());
        res.append(" ");
        res.append(this.count);
        res.append(" ");
        res.append(this.elapsed);
        return res.toString();
    }

    public int getCount() {
        return this.count;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public long getMaxTotMem() {
        return this.maxTotMem;
    }

    public long getMaxUsedMem() {
        return this.maxUsedMem;
    }

    public int getNumParallelTasks() {
        return this.numParallelTasks;
    }

    public PerfTask getTask() {
        return this.task;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public void add(TaskStats stat2) {
        this.numRuns += stat2.getNumRuns();
        this.elapsed += stat2.getElapsed();
        this.maxTotMem += stat2.getMaxTotMem();
        this.maxUsedMem += stat2.getMaxUsedMem();
        this.count += stat2.getCount();
        if (this.round != stat2.round) {
            this.round = -1;
        }
        if (this.countsByTime != null && stat2.countsByTime != null) {
            if (this.countsByTimeStepMSec != stat2.countsByTimeStepMSec) {
                throw new IllegalStateException("different by-time msec step");
            }
            if (this.countsByTime.length != stat2.countsByTime.length) {
                throw new IllegalStateException("different by-time msec count");
            }
            for (int i = 0; i < stat2.countsByTime.length; ++i) {
                int n = i;
                this.countsByTime[n] = this.countsByTime[n] + stat2.countsByTime[i];
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TaskStats c = (TaskStats)super.clone();
        if (c.countsByTime != null) {
            c.countsByTime = (int[])c.countsByTime.clone();
        }
        return c;
    }

    public int getRound() {
        return this.round;
    }
}

