/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality;

import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;

public class QualityStats {
    public static final int MAX_POINTS = 20;
    private double maxGoodPoints;
    private double recall;
    private double[] pAt;
    private double pReleventSum = 0.0;
    private double numPoints = 0.0;
    private double numGoodPoints = 0.0;
    private double mrr = 0.0;
    private long searchTime;
    private long docNamesExtractTime;
    private ArrayList<RecallPoint> recallPoints;
    private static String padd = "                                    ";

    public QualityStats(double maxGoodPoints, long searchTime) {
        this.maxGoodPoints = maxGoodPoints;
        this.searchTime = searchTime;
        this.recallPoints = new ArrayList();
        this.pAt = new double[21];
    }

    public void addResult(int n, boolean isRelevant, long docNameExtractTime) {
        if (Math.abs(this.numPoints + 1.0 - (double)n) > 1.0E-6) {
            throw new IllegalArgumentException("point " + n + " illegal after " + this.numPoints + " points!");
        }
        if (isRelevant) {
            this.numGoodPoints += 1.0;
            this.recallPoints.add(new RecallPoint(n, this.numGoodPoints));
            if (this.recallPoints.size() == 1 && n <= 5) {
                this.mrr = 1.0 / (double)n;
            }
        }
        this.numPoints = n;
        double p = this.numGoodPoints / this.numPoints;
        if (isRelevant) {
            this.pReleventSum += p;
        }
        if (n < this.pAt.length) {
            this.pAt[n] = p;
        }
        this.recall = this.maxGoodPoints <= 0.0 ? p : this.numGoodPoints / this.maxGoodPoints;
        this.docNamesExtractTime += docNameExtractTime;
    }

    public double getPrecisionAt(int n) {
        if (n < 1 || n > 20) {
            throw new IllegalArgumentException("n=" + n + " - but it must be in [1," + 20 + "] range!");
        }
        if ((double)n > this.numPoints) {
            return this.numPoints * this.pAt[(int)this.numPoints] / (double)n;
        }
        return this.pAt[n];
    }

    public double getAvp() {
        return this.maxGoodPoints == 0.0 ? 0.0 : this.pReleventSum / this.maxGoodPoints;
    }

    public double getRecall() {
        return this.recall;
    }

    public void log(String title, int paddLines, PrintWriter logger, String prefix) {
        int i;
        for (int i2 = 0; i2 < paddLines; ++i2) {
            logger.println();
        }
        if (title != null && title.trim().length() > 0) {
            logger.println(title);
        }
        prefix = prefix == null ? "" : prefix;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        nf.setGroupingUsed(true);
        int M = 19;
        logger.println(prefix + this.format("Search Seconds: ", M) + this.fracFormat(nf.format((double)this.searchTime / 1000.0)));
        logger.println(prefix + this.format("DocName Seconds: ", M) + this.fracFormat(nf.format((double)this.docNamesExtractTime / 1000.0)));
        logger.println(prefix + this.format("Num Points: ", M) + this.fracFormat(nf.format(this.numPoints)));
        logger.println(prefix + this.format("Num Good Points: ", M) + this.fracFormat(nf.format(this.numGoodPoints)));
        logger.println(prefix + this.format("Max Good Points: ", M) + this.fracFormat(nf.format(this.maxGoodPoints)));
        logger.println(prefix + this.format("Average Precision: ", M) + this.fracFormat(nf.format(this.getAvp())));
        logger.println(prefix + this.format("MRR: ", M) + this.fracFormat(nf.format(this.getMRR())));
        logger.println(prefix + this.format("Recall: ", M) + this.fracFormat(nf.format(this.getRecall())));
        for (i = 1; i < (int)this.numPoints && i < this.pAt.length; ++i) {
            logger.println(prefix + this.format("Precision At " + i + ": ", M) + this.fracFormat(nf.format(this.getPrecisionAt(i))));
        }
        for (i = 0; i < paddLines; ++i) {
            logger.println();
        }
    }

    private String format(String s, int minLen) {
        s = s == null ? "" : s;
        int n = Math.max(minLen, s.length());
        return (s + padd).substring(0, n);
    }

    private String fracFormat(String frac) {
        int k = frac.indexOf(46);
        String s1 = padd + frac.substring(0, k);
        int n = Math.max(k, 6);
        s1 = s1.substring(s1.length() - n);
        return s1 + frac.substring(k);
    }

    public static QualityStats average(QualityStats[] stats) {
        QualityStats avg = new QualityStats(0.0, 0L);
        if (stats.length == 0) {
            return avg;
        }
        int m = 0;
        for (int i = 0; i < stats.length; ++i) {
            avg.searchTime += stats[i].searchTime;
            avg.docNamesExtractTime += stats[i].docNamesExtractTime;
            if (!(stats[i].maxGoodPoints > 0.0)) continue;
            ++m;
            avg.numGoodPoints += stats[i].numGoodPoints;
            avg.numPoints += stats[i].numPoints;
            avg.pReleventSum += stats[i].getAvp();
            avg.recall += stats[i].recall;
            avg.mrr += stats[i].getMRR();
            avg.maxGoodPoints += stats[i].maxGoodPoints;
            for (int j = 1; j < avg.pAt.length; ++j) {
                int n = j;
                avg.pAt[n] = avg.pAt[n] + stats[i].getPrecisionAt(j);
            }
        }
        assert (m > 0) : "Fishy: no \"good\" queries!";
        avg.searchTime /= (long)stats.length;
        avg.docNamesExtractTime /= (long)stats.length;
        avg.numGoodPoints /= (double)m;
        avg.numPoints /= (double)m;
        avg.recall /= (double)m;
        avg.mrr /= (double)m;
        avg.maxGoodPoints /= (double)m;
        int j = 1;
        while (j < avg.pAt.length) {
            int n = j++;
            avg.pAt[n] = avg.pAt[n] / (double)m;
        }
        avg.pReleventSum /= (double)m;
        avg.pReleventSum *= avg.maxGoodPoints;
        return avg;
    }

    public long getDocNamesExtractTime() {
        return this.docNamesExtractTime;
    }

    public double getMaxGoodPoints() {
        return this.maxGoodPoints;
    }

    public double getNumGoodPoints() {
        return this.numGoodPoints;
    }

    public double getNumPoints() {
        return this.numPoints;
    }

    public RecallPoint[] getRecallPoints() {
        return this.recallPoints.toArray(new RecallPoint[0]);
    }

    public double getMRR() {
        return this.mrr;
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public static class RecallPoint {
        private int rank;
        private double recall;

        private RecallPoint(int rank, double recall) {
            this.rank = rank;
            this.recall = recall;
        }

        public int getRank() {
            return this.rank;
        }

        public double getRecall() {
            return this.recall;
        }
    }
}

