/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class UpdateDocTask
extends PerfTask {
    private int docSize = 0;
    private Document doc = null;

    public UpdateDocTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = this.docSize > 0 ? docMaker.makeDocument(this.docSize) : docMaker.makeDocument();
    }

    public void tearDown() throws Exception {
        this.doc = null;
        super.tearDown();
    }

    public int doLogic() throws Exception {
        String docID = this.doc.get("docid");
        if (docID == null) {
            throw new IllegalStateException("document must define the docid field");
        }
        IndexWriter iw = this.getRunData().getIndexWriter();
        iw.updateDocument(new Term("docid", docID), this.doc);
        return 1;
    }

    protected String getLogMessage(int recsCount) {
        return "updated " + recsCount + " docs";
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

