/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.util.Version;

public class NewShingleAnalyzerTask
extends PerfTask {
    private String analyzerClassName = "standard.StandardAnalyzer";
    private int maxShingleSize = 2;
    private boolean outputUnigrams = true;

    public NewShingleAnalyzerTask(PerfRunData runData) {
        super(runData);
    }

    private void setAnalyzer() throws Exception {
        Analyzer wrappedAnalyzer;
        Class<Analyzer> clazz = null;
        try {
            if (this.analyzerClassName == null || this.analyzerClassName.equals("")) {
                this.analyzerClassName = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            }
            if (this.analyzerClassName.indexOf(".") == -1 || this.analyzerClassName.startsWith("standard.")) {
                this.analyzerClassName = "org.apache.lucene.analysis." + this.analyzerClassName;
            }
            clazz = Class.forName(this.analyzerClassName).asSubclass(Analyzer.class);
            Constructor<Analyzer> ctor = clazz.getConstructor(Version.class);
            wrappedAnalyzer = ctor.newInstance(Version.LUCENE_CURRENT);
        }
        catch (NoSuchMethodException e) {
            wrappedAnalyzer = (Analyzer)clazz.newInstance();
        }
        ShingleAnalyzerWrapper analyzer = new ShingleAnalyzerWrapper(wrappedAnalyzer, 2, this.maxShingleSize, " ", this.outputUnigrams, false);
        this.getRunData().setAnalyzer((Analyzer)analyzer);
    }

    public int doLogic() throws Exception {
        try {
            this.setAnalyzer();
            System.out.println("Changed Analyzer to: ShingleAnalyzerWrapper, wrapping ShingleFilter over" + this.analyzerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Analyzer", e);
        }
        return 1;
    }

    public void setParams(String params) {
        super.setParams(params);
        StringTokenizer st = new StringTokenizer(params, ",");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            StringTokenizer expr = new StringTokenizer(param, ":");
            String key = expr.nextToken();
            String value = expr.nextToken();
            if (key.equalsIgnoreCase("analyzer")) {
                this.analyzerClassName = value;
                continue;
            }
            if (key.equalsIgnoreCase("outputUnigrams")) {
                this.outputUnigrams = Boolean.parseBoolean(value);
                continue;
            }
            if (key.equalsIgnoreCase("maxShingleSize")) {
                this.maxShingleSize = (int)Double.parseDouble(value);
                continue;
            }
            throw new RuntimeException("Unknown parameter " + param);
        }
    }

    public boolean supportsParams() {
        return true;
    }
}

