/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.util.Version;

public class NewAnalyzerTask
extends PerfTask {
    private List<String> analyzerClassNames = new ArrayList<String>();
    private int current;

    public NewAnalyzerTask(PerfRunData runData) {
        super(runData);
    }

    public static final Analyzer createAnalyzer(String className) throws Exception {
        Class<Analyzer> clazz = Class.forName(className).asSubclass(Analyzer.class);
        try {
            Constructor<Analyzer> cnstr = clazz.getConstructor(Version.class);
            return cnstr.newInstance(Version.LUCENE_CURRENT);
        }
        catch (NoSuchMethodException nsme) {
            return clazz.newInstance();
        }
    }

    public int doLogic() throws IOException {
        String className = null;
        try {
            if (this.current >= this.analyzerClassNames.size()) {
                this.current = 0;
            }
            if ((className = this.analyzerClassNames.get(this.current++)) == null || className.equals("")) {
                className = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            }
            if (className.indexOf(".") == -1 || className.startsWith("standard.")) {
                className = "org.apache.lucene.analysis." + className;
            }
            this.getRunData().setAnalyzer(NewAnalyzerTask.createAnalyzer(className));
            System.out.println("Changed Analyzer to: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Analyzer: " + className, e);
        }
        return 1;
    }

    public void setParams(String params) {
        super.setParams(params);
        StringTokenizer tokenizer = new StringTokenizer(params, ",");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            this.analyzerClassNames.add(s.trim());
        }
    }

    public boolean supportsParams() {
        return true;
    }
}

