/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.HTMLParser;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.feeds.TrecDocParser;
import org.apache.lucene.benchmark.byTask.feeds.TrecGov2Parser;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.StreamUtils;
import org.apache.lucene.benchmark.byTask.utils.StringBuilderReader;
import org.apache.lucene.util.ThreadInterruptedException;

public class TrecContentSource
extends ContentSource {
    public static final String DOCNO = "<DOCNO>";
    public static final String TERMINATING_DOCNO = "</DOCNO>";
    public static final String DOC = "<DOC>";
    public static final String TERMINATING_DOC = "</DOC>";
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy kk:mm:ss z", "EEE MMM dd kk:mm:ss yyyy z", "EEE, dd-MMM-':'y kk:mm:ss z", "EEE, dd-MMM-yyy kk:mm:ss z", "EEE MMM dd kk:mm:ss yyyy", "dd MMM yyyy", "MMM dd, yyyy", "yyMMdd", "hhmm z.z.z. MMM dd, yyyy"};
    private ThreadLocal<DateFormatInfo> dateFormats = new ThreadLocal();
    private ThreadLocal<StringBuilderReader> trecDocReader = new ThreadLocal();
    private ThreadLocal<StringBuilder> trecDocBuffer = new ThreadLocal();
    private File dataDir = null;
    private ArrayList<File> inputFiles = new ArrayList();
    private int nextFile = 0;
    private int rawDocSize = 0;
    private Object lock = new Object();
    BufferedReader reader;
    int iteration = 0;
    HTMLParser htmlParser;
    private boolean excludeDocnameIteration;
    private TrecDocParser trecDocParser = new TrecGov2Parser();
    TrecDocParser.ParsePathType currPathType;

    private DateFormatInfo getDateFormatInfo() {
        DateFormatInfo dfi = this.dateFormats.get();
        if (dfi == null) {
            dfi = new DateFormatInfo();
            dfi.dfs = new SimpleDateFormat[DATE_FORMATS.length];
            for (int i = 0; i < dfi.dfs.length; ++i) {
                dfi.dfs[i] = new SimpleDateFormat(DATE_FORMATS[i], Locale.US);
                dfi.dfs[i].setLenient(true);
            }
            dfi.pos = new ParsePosition(0);
            this.dateFormats.set(dfi);
        }
        return dfi;
    }

    private StringBuilder getDocBuffer() {
        StringBuilder sb = this.trecDocBuffer.get();
        if (sb == null) {
            sb = new StringBuilder();
            this.trecDocBuffer.set(sb);
        }
        return sb;
    }

    Reader getTrecDocReader(StringBuilder docBuffer) {
        StringBuilderReader r = this.trecDocReader.get();
        if (r == null) {
            r = new StringBuilderReader(docBuffer);
            this.trecDocReader.set(r);
        } else {
            r.set(docBuffer);
        }
        return r;
    }

    HTMLParser getHtmlParser() {
        return this.htmlParser;
    }

    private void read(StringBuilder buf, String lineStart, boolean collectMatchLine, boolean collectAll) throws IOException, NoMoreDataException {
        String sep = "";
        while (true) {
            String line;
            if ((line = this.reader.readLine()) == null) {
                this.openNextFile();
                continue;
            }
            this.rawDocSize += line.length();
            if (lineStart != null && line.startsWith(lineStart)) {
                if (collectMatchLine) {
                    buf.append(sep).append(line);
                    sep = NEW_LINE;
                }
                return;
            }
            if (!collectAll) continue;
            buf.append(sep).append(line);
            sep = NEW_LINE;
        }
    }

    void openNextFile() throws NoMoreDataException, IOException {
        this.close();
        this.currPathType = null;
        while (true) {
            if (this.nextFile >= this.inputFiles.size()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.nextFile = 0;
                ++this.iteration;
            }
            File f = this.inputFiles.get(this.nextFile++);
            if (this.verbose) {
                System.out.println("opening: " + f + " length: " + f.length());
            }
            try {
                InputStream inputStream = StreamUtils.inputStream(f);
                this.reader = new BufferedReader(new InputStreamReader(inputStream, this.encoding), 65536);
                this.currPathType = TrecDocParser.pathType(f);
                return;
            }
            catch (Exception e) {
                if (this.verbose) {
                    System.out.println("Skipping 'bad' file " + f.getAbsolutePath() + " due to " + e.getMessage());
                    continue;
                }
                throw new NoMoreDataException();
            }
            break;
        }
    }

    public Date parseDate(String dateStr) {
        dateStr = dateStr.trim();
        DateFormatInfo dfi = this.getDateFormatInfo();
        for (int i = 0; i < dfi.dfs.length; ++i) {
            DateFormat df = dfi.dfs[i];
            dfi.pos.setIndex(0);
            dfi.pos.setErrorIndex(-1);
            Date d = df.parse(dateStr, dfi.pos);
            if (d == null) continue;
            return d;
        }
        if (this.verbose) {
            System.out.println("failed to parse date (assigning 'now') for: " + dateStr);
        }
        return null;
    }

    public void close() throws IOException {
        block3: {
            if (this.reader == null) {
                return;
            }
            try {
                this.reader.close();
            }
            catch (IOException e) {
                if (!this.verbose) break block3;
                System.out.println("failed to close reader !");
                e.printStackTrace(System.out);
            }
        }
        this.reader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        TrecDocParser.ParsePathType parsedPathType;
        String name = null;
        StringBuilder docBuf = this.getDocBuffer();
        Object object = this.lock;
        synchronized (object) {
            if (this.reader == null) {
                this.openNextFile();
            }
            docBuf.setLength(0);
            this.read(docBuf, DOC, false, false);
            parsedPathType = this.currPathType;
            docBuf.setLength(0);
            this.read(docBuf, DOCNO, true, false);
            name = docBuf.substring(DOCNO.length(), docBuf.indexOf(TERMINATING_DOCNO, DOCNO.length())).trim();
            if (!this.excludeDocnameIteration) {
                name = name + "_" + this.iteration;
            }
            docBuf.setLength(0);
            this.read(docBuf, TERMINATING_DOC, false, true);
        }
        this.addBytes(docBuf.length());
        try {
            docData = this.trecDocParser.parse(docData, name, this, docBuf, parsedPathType);
            this.addItem();
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
        return docData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInputs() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.resetInputs();
            this.close();
            this.nextFile = 0;
            this.iteration = 0;
        }
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        File workDir = new File(config.get("work.dir", "work"));
        String d = config.get("docs.dir", "trec");
        this.dataDir = new File(d);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = new File(workDir, d);
        }
        this.collectFiles(this.dataDir, this.inputFiles);
        if (this.inputFiles.size() == 0) {
            throw new IllegalArgumentException("No files in dataDir: " + this.dataDir);
        }
        try {
            String trecDocParserClassName = config.get("trec.doc.parser", "org.apache.lucene.benchmark.byTask.feeds.TrecGov2Parser");
            this.trecDocParser = Class.forName(trecDocParserClassName).asSubclass(TrecDocParser.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String htmlParserClassName = config.get("html.parser", "org.apache.lucene.benchmark.byTask.feeds.DemoHTMLParser");
            this.htmlParser = Class.forName(htmlParserClassName).asSubclass(HTMLParser.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
        }
        this.excludeDocnameIteration = config.get("content.source.excludeIteration", false);
    }

    private static final class DateFormatInfo {
        DateFormat[] dfs;
        ParsePosition pos;

        DateFormatInfo() {
        }
    }
}

