/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class WriteLineDocTask
extends PerfTask {
    public static final char SEP = '\t';
    private int docSize = 0;
    private PrintWriter lineFileOut = null;
    private DocMaker docMaker;
    private ThreadLocal<StringBuilder> threadBuffer = new ThreadLocal();
    private ThreadLocal<Matcher> threadNormalizer = new ThreadLocal();

    public WriteLineDocTask(PerfRunData runData) throws Exception {
        super(runData);
        Config config = runData.getConfig();
        String fileName = config.get("line.file.out", null);
        if (fileName == null) {
            throw new IllegalArgumentException("line.file.out must be set");
        }
        OutputStream out = new FileOutputStream(fileName);
        boolean doBzipCompression = false;
        String doBZCompress = config.get("bzip.compression", null);
        doBzipCompression = doBZCompress != null ? Boolean.valueOf(doBZCompress).booleanValue() : fileName.endsWith("bz2");
        if (doBzipCompression) {
            out = new BufferedOutputStream(out, 65536);
            out = new CompressorStreamFactory().createCompressorOutputStream("bzip2", out);
        }
        this.lineFileOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, "UTF-8"), 65536));
        this.docMaker = runData.getDocMaker();
    }

    protected String getLogMessage(int recsCount) {
        return "Wrote " + recsCount + " line docs";
    }

    public int doLogic() throws Exception {
        String title;
        Field f;
        Document doc = this.docSize > 0 ? this.docMaker.makeDocument(this.docSize) : this.docMaker.makeDocument();
        Matcher matcher = this.threadNormalizer.get();
        if (matcher == null) {
            matcher = Pattern.compile("[\t\r\n]+").matcher("");
            this.threadNormalizer.set(matcher);
        }
        String body = (f = doc.getField("body")) != null ? matcher.reset(f.stringValue()).replaceAll(" ") : "";
        f = doc.getField("doctitle");
        String string = title = f != null ? matcher.reset(f.stringValue()).replaceAll(" ") : "";
        if (body.length() > 0 || title.length() > 0) {
            f = doc.getField("docdate");
            String date = f != null ? matcher.reset(f.stringValue()).replaceAll(" ") : "";
            StringBuilder sb = this.threadBuffer.get();
            if (sb == null) {
                sb = new StringBuilder();
                this.threadBuffer.set(sb);
            }
            sb.setLength(0);
            sb.append(title).append('\t').append(date).append('\t').append(body);
            this.lineFileOut.println(sb.toString());
        }
        return 1;
    }

    public void close() throws Exception {
        this.lineFileOut.close();
        super.close();
    }

    public void setParams(String params) {
        super.setParams(params);
        this.docSize = (int)Float.parseFloat(params);
    }

    public boolean supportsParams() {
        return true;
    }
}

