/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentSource {
    private static final int BZIP = 0;
    private static final int GZIP = 1;
    private static final int OTHER = 2;
    private static final Map<String, Integer> extensionToType = new HashMap<String, Integer>();
    protected static final int BUFFER_SIZE = 65536;
    private long bytesCount;
    private long totalBytesCount;
    private int docsCount;
    private int totalDocsCount;
    private Config config;
    protected boolean forever;
    protected int logStep;
    protected boolean verbose;
    protected String encoding;
    private CompressorStreamFactory csFactory = new CompressorStreamFactory();

    protected final synchronized void addBytes(long numBytes) {
        this.bytesCount += numBytes;
        this.totalBytesCount += numBytes;
    }

    protected final synchronized void addDoc() {
        ++this.docsCount;
        ++this.totalDocsCount;
    }

    protected final void collectFiles(File dir, ArrayList<File> files) {
        if (!dir.canRead()) {
            return;
        }
        Object[] dirFiles = dir.listFiles();
        Arrays.sort(dirFiles);
        for (int i = 0; i < dirFiles.length; ++i) {
            Object file = dirFiles[i];
            if (((File)file).isDirectory()) {
                this.collectFiles((File)file, files);
                continue;
            }
            if (!((File)file).canRead()) continue;
            files.add((File)file);
        }
    }

    protected InputStream getInputStream(File file) throws IOException {
        Integer typeInt;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 65536);
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(46);
        int type = 2;
        if (idx != -1 && (typeInt = extensionToType.get(fileName.substring(idx))) != null) {
            type = typeInt;
        }
        try {
            switch (type) {
                case 0: {
                    is = this.csFactory.createCompressorInputStream("bzip2", (InputStream)is);
                    break;
                }
                case 1: {
                    is = this.csFactory.createCompressorInputStream("gz", (InputStream)is);
                    break;
                }
            }
        }
        catch (CompressorException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return is;
    }

    protected final boolean shouldLog() {
        return this.verbose && this.logStep > 0 && this.docsCount % this.logStep == 0;
    }

    public abstract void close() throws IOException;

    public final long getBytesCount() {
        return this.bytesCount;
    }

    public final int getDocsCount() {
        return this.docsCount;
    }

    public final Config getConfig() {
        return this.config;
    }

    public abstract DocData getNextDocData(DocData var1) throws NoMoreDataException, IOException;

    public final long getTotalBytesCount() {
        return this.totalBytesCount;
    }

    public final int getTotalDocsCount() {
        return this.totalDocsCount;
    }

    public void resetInputs() throws IOException {
        this.bytesCount = 0L;
        this.docsCount = 0;
    }

    public void setConfig(Config config) {
        this.config = config;
        this.forever = config.get("content.source.forever", true);
        this.logStep = config.get("content.source.log.step", 0);
        this.verbose = config.get("content.source.verbose", false);
        this.encoding = config.get("content.source.encoding", null);
    }

    static {
        extensionToType.put(".bz2", 0);
        extensionToType.put(".bzip", 0);
        extensionToType.put(".gz", 1);
        extensionToType.put(".gzip", 1);
    }
}

