/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.trec;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.lucene.benchmark.quality.QualityQuery;

public class TrecTopicsReader {
    private static final String newline = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QualityQuery[] readQueries(BufferedReader reader) throws IOException {
        ArrayList<QualityQuery> res = new ArrayList<QualityQuery>();
        try {
            StringBuffer sb;
            while (null != (sb = this.read(reader, "<top>", null, false, false))) {
                HashMap<String, String> fields = new HashMap<String, String>();
                sb = this.read(reader, "<num>", null, true, false);
                int k = sb.indexOf(":");
                String id = sb.substring(k + 1).trim();
                sb = this.read(reader, "<title>", null, true, false);
                k = sb.indexOf(">");
                String title = sb.substring(k + 1).trim();
                sb = this.read(reader, "<desc>", null, false, false);
                sb = this.read(reader, "<narr>", null, false, true);
                String descripion = sb.toString().trim();
                fields.put("title", title);
                fields.put("description", descripion);
                QualityQuery topic = new QualityQuery(id, fields);
                res.add(topic);
                this.read(reader, "</top>", null, false, false);
            }
        }
        finally {
            reader.close();
        }
        Object[] qq = res.toArray(new QualityQuery[0]);
        Arrays.sort(qq);
        return qq;
    }

    private StringBuffer read(BufferedReader reader, String prefix, StringBuffer sb, boolean collectMatchLine, boolean collectAll) throws IOException {
        sb = sb == null ? new StringBuffer() : sb;
        String sep = "";
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) {
                return null;
            }
            if (line.startsWith(prefix)) {
                if (!collectMatchLine) break;
                sb.append(sep + line);
                sep = newline;
                break;
            }
            if (!collectAll) continue;
            sb.append(sep + line);
            sep = newline;
        }
        return sb;
    }
}

