/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.trec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import org.apache.lucene.benchmark.quality.QualityBenchmark;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.QualityStats;
import org.apache.lucene.benchmark.quality.trec.TrecJudge;
import org.apache.lucene.benchmark.quality.trec.TrecTopicsReader;
import org.apache.lucene.benchmark.quality.utils.SimpleQQParser;
import org.apache.lucene.benchmark.quality.utils.SubmissionReport;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;

public class QueryDriver {
    public static void main(String[] args) throws Exception {
        File topicsFile = new File(args[0]);
        File qrelsFile = new File(args[1]);
        IndexSearcher searcher = new IndexSearcher(args[3]);
        int maxResults = 1000;
        String docNameField = "docname";
        PrintWriter logger = new PrintWriter(System.out, true);
        TrecTopicsReader qReader = new TrecTopicsReader();
        QualityQuery[] qqs = qReader.readQueries(new BufferedReader(new FileReader(topicsFile)));
        TrecJudge judge = new TrecJudge(new BufferedReader(new FileReader(qrelsFile)));
        judge.validateData(qqs, logger);
        SimpleQQParser qqParser = new SimpleQQParser("title", "body");
        QualityBenchmark qrun = new QualityBenchmark(qqs, qqParser, (Searcher)searcher, docNameField);
        qrun.setMaxResults(maxResults);
        SubmissionReport submitLog = null;
        QualityStats[] stats = qrun.execute(judge, submitLog, logger);
        QualityStats avg = QualityStats.average(stats);
        avg.log("SUMMARY", 2, logger, "  ");
    }
}

