/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality;

import java.util.Map;

public class QualityQuery
implements Comparable {
    private String queryID;
    private Map nameValPairs;

    public QualityQuery(String queryID, Map nameValPairs) {
        this.queryID = queryID;
        this.nameValPairs = nameValPairs;
    }

    public String[] getNames() {
        return this.nameValPairs.keySet().toArray(new String[0]);
    }

    public String getValue(String name) {
        return (String)this.nameValPairs.get(name);
    }

    public String getQueryID() {
        return this.queryID;
    }

    public int compareTo(Object o) {
        QualityQuery other = (QualityQuery)o;
        try {
            int n = Integer.parseInt(this.queryID);
            int nOther = Integer.parseInt(other.queryID);
            return n - nOther;
        }
        catch (NumberFormatException e) {
            return this.queryID.compareTo(other.queryID);
        }
    }
}

