/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.utils;

import java.io.IOException;
import java.io.Reader;

public class StringBufferReader
extends Reader {
    private StringBuffer sb;
    private int length;
    private int next = 0;
    private int mark = 0;

    public StringBufferReader(StringBuffer sb) {
        this.set(sb);
    }

    private void ensureOpen() throws IOException {
        if (this.sb == null) {
            throw new IOException("Stream has already been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.sb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit cannpt be negative: " + readAheadLimit);
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.next >= this.length ? -1 : (int)this.sb.charAt(this.next++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length) {
                throw new IndexOutOfBoundsException("off=" + off + " len=" + len + " cbuf.length=" + cbuf.length);
            }
            if (len == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n = Math.min(this.length - this.next, len);
            this.sb.getChars(this.next, this.next + n, cbuf, off);
            this.next += n;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.next = this.mark;
            this.length = this.sb.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(StringBuffer sb) {
        Object object = this.lock;
        synchronized (object) {
            this.sb = sb;
            this.length = sb.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long ns) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                return 0L;
            }
            long n = Math.min((long)(this.length - this.next), ns);
            n = Math.max((long)(-this.next), n);
            this.next = (int)((long)this.next + n);
            return n;
        }
    }
}

