/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.feeds.AbstractQueryMaker;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;

public class FileBasedQueryMaker
extends AbstractQueryMaker
implements QueryMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query[] prepareQueries() throws Exception {
        Analyzer anlzr = (Analyzer)Class.forName(this.config.get("analyzer", "org.apache.lucene.analysis.standard.StandardAnalyzer")).newInstance();
        String defaultField = this.config.get("file.query.maker.default.field", "body");
        QueryParser qp = new QueryParser(defaultField, anlzr);
        ArrayList<Query> qq = new ArrayList<Query>();
        String fileName = this.config.get("file.query.maker.file", null);
        if (fileName != null) {
            File file = new File(fileName);
            InputStreamReader reader = null;
            if (file.exists()) {
                reader = new FileReader(file);
            } else {
                InputStream asStream = FileBasedQueryMaker.class.getClassLoader().getResourceAsStream(fileName);
                if (asStream != null) {
                    reader = new InputStreamReader(asStream);
                }
            }
            if (reader != null) {
                try {
                    BufferedReader buffered = new BufferedReader(reader);
                    String line = null;
                    int lineNum = 0;
                    while ((line = buffered.readLine()) != null) {
                        if (!(line = line.trim()).equals("") && !line.startsWith("#")) {
                            Query query = null;
                            try {
                                query = qp.parse(line);
                            }
                            catch (ParseException e) {
                                System.err.println("Exception: " + e.getMessage() + " occurred while parsing line: " + lineNum + " Text: " + line);
                            }
                            qq.add(query);
                        }
                        ++lineNum;
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            System.err.println("No Reader available for: " + fileName);
        }
        Query[] result = qq.toArray(new Query[qq.size()]);
        return result;
    }
}

